/*
 * Decompiled with CFR 0.152.
 */
package com.fjwangjia.android.seele;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.util.Log;
import com.fjwangjia.android.seele.FileTool;
import com.fjwangjia.android.seele.PatchLoader;
import com.fjwangjia.android.seele.Verify;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class BugFix {
    static String BASE_URL = "";
    static String PATCH_DIR = "";
    static String PATCH_FILE = "apk.patch";
    static String DEX_OPT_DIR = "OPT_DIR";
    static String PERSISTENCE_NAME = "SEELE_BUG_FIX";
    static String LAST_VERSION = "LAST_VERSION";
    static Context mContext = null;
    static int mCurrentVersion;
    static Verify mVerify;
    static PatchLoader mPatchLoader;

    public static void init(Context context) {
        File file;
        mContext = context;
        BASE_URL = context.getFilesDir() + "PATCH_DIR/";
        PATCH_DIR = BASE_URL + mCurrentVersion + '/';
        mVerify = new Verify(context);
        mPatchLoader = new PatchLoader();
        mCurrentVersion = 0;
        try {
            String pkName = context.getPackageName();
            mCurrentVersion = context.getPackageManager().getPackageInfo((String)pkName, (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        int iRecordVersion = BugFix.getRecordVersion(context);
        if (iRecordVersion < mCurrentVersion) {
            BugFix.cleanPatch();
        }
        if (!(file = new File(PATCH_DIR)).exists()) {
            file.mkdirs();
        } else {
            BugFix.loadPatch();
        }
    }

    public static int getRecordVersion(Context context) {
        if (null != context) {
            SharedPreferences sp = context.getSharedPreferences(PERSISTENCE_NAME, 0);
            return sp.getInt(LAST_VERSION, -1);
        }
        return 0;
    }

    public static void setRecordVersion(Context context, int version) {
        SharedPreferences sp = context.getSharedPreferences(PERSISTENCE_NAME, 0);
        sp.edit().putInt(LAST_VERSION, version).commit();
    }

    private static void loadPatch() {
        File patchDir = new File(PATCH_DIR);
        ArrayList<File> patchList = new ArrayList<File>();
        for (File patch : patchDir.listFiles()) {
            if (patch.isFile() && mVerify.verify(patch)) {
                patchList.add(patch);
                continue;
            }
            Log.e((String)"seele_bug_fix", (String)("verify fail or is dir" + patch.getAbsolutePath()));
        }
        if (patchList.size() != 0) {
            File dexOptDir = new File(PATCH_DIR, DEX_OPT_DIR);
            dexOptDir.mkdir();
            mPatchLoader.load((File[])patchList.toArray(), dexOptDir);
        }
    }

    public static void loadPatch(File src) {
        File dest = new File(PATCH_DIR, src.getName());
        if (src == null || !src.exists()) {
            Log.e((String)"seele_bug_fix", (String)("there is not exists file : " + src.getAbsolutePath()));
            return;
        }
        if (dest.exists()) {
            return;
        }
        if (!mVerify.verify(src)) {
            Log.e((String)"seele_bug_fix", (String)("verify fail" + src.getAbsolutePath()));
            return;
        }
        try {
            FileTool.copyFile(src, dest);
            File dexOptDir = new File(PATCH_DIR, DEX_OPT_DIR);
            dexOptDir.mkdir();
            mPatchLoader.load(dest, dexOptDir);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void loadPatch(String path) {
        File src = new File(path);
        BugFix.loadPatch(src);
    }

    public static void cleanPatch() {
        if (mContext != null) {
            File baseDir = new File(BASE_URL);
            FileTool.deleteDir(baseDir);
        }
    }

    static {
        mVerify = null;
        mPatchLoader = null;
    }
}

