/*
 * Decompiled with CFR 0.152.
 */
package com.fjwangjia.android.seele;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.util.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;

public class BugFix {
    static String BASE_URL = "";
    static String PATCH_DIR = "";
    static String PERSISTENCE_NAME = "/SEELE_BUG_FIX";
    static String LAST_VERSION = "LAST_VERSION";
    static Context mContext = null;
    static int mCurrentVersion;

    public static void init(Context context) {
        File file;
        mContext = context;
        BASE_URL = context.getFilesDir() + "PATCH_DIR/";
        PATCH_DIR = BASE_URL + mCurrentVersion;
        mCurrentVersion = 0;
        try {
            String pkName = context.getPackageName();
            mCurrentVersion = context.getPackageManager().getPackageInfo((String)pkName, (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        int iRecordVersion = BugFix.getRecordVersion(context);
        if (iRecordVersion < mCurrentVersion) {
            BugFix.cleanPatch();
        }
        if (!(file = new File(PATCH_DIR)).exists()) {
            file.mkdirs();
        } else {
            BugFix.loadPatch();
        }
    }

    public static int getRecordVersion(Context context) {
        if (null != context) {
            SharedPreferences sp = context.getSharedPreferences(PERSISTENCE_NAME, 0);
            return sp.getInt(LAST_VERSION, -1);
        }
        return 0;
    }

    public static void setRecordVersion(Context context, int version) {
        SharedPreferences sp = context.getSharedPreferences(PERSISTENCE_NAME, 0);
        sp.edit().putInt(LAST_VERSION, version).commit();
    }

    private static void loadPatch() {
        File patchDir = new File(PATCH_DIR);
        ArrayList<File> patchList = new ArrayList<File>();
        for (File patch : patchDir.listFiles()) {
            if (!patch.isFile()) continue;
            patchList.add(patch);
        }
    }

    public static void loadPatch(File src) {
        File dest = new File(PATCH_DIR, src.getName());
        if (!src.exists()) {
            Log.d((String)"seele_bug_fix", (String)("there is not exists file : " + src.getAbsolutePath()));
            return;
        }
        if (dest.exists()) {
            return;
        }
        try {
            BugFix.copyFile(src, dest);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File src, File dest) throws IOException {
        AbstractInterruptibleChannel inChannel = null;
        AbstractInterruptibleChannel outChannel = null;
        try {
            if (!dest.exists()) {
                dest.createNewFile();
            }
            inChannel = new FileInputStream(src).getChannel();
            outChannel = new FileOutputStream(dest).getChannel();
            ((FileChannel)inChannel).transferTo(0L, ((FileChannel)inChannel).size(), (WritableByteChannel)((Object)outChannel));
        }
        finally {
            if (inChannel != null) {
                inChannel.close();
            }
            if (outChannel != null) {
                outChannel.close();
            }
        }
    }

    public static void loadPatch(String path) {
        File src = new File(path);
        BugFix.loadPatch(src);
    }

    public static void cleanPatch() {
        if (mContext != null) {
            File baseDir = new File(BASE_URL);
            baseDir.delete();
        }
    }
}

