/*
 * Decompiled with CFR 0.152.
 */
package com.fjwangjia.android.richfonttextview;

import android.content.Context;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.widget.TextView;
import com.fjwangjia.android.richfonttextview.tag.Tag;
import com.fjwangjia.android.richfonttextview.xml.XmlParser;
import java.util.List;

public class RichFontTextView
extends TextView {
    public RichFontTextView(Context context) {
        super(context);
    }

    public RichFontTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public RichFontTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        XmlParser xmlParser;
        List<Tag> tags;
        if (TextView.BufferType.SPANNABLE == type) {
            super.setText(text, type);
            return;
        }
        if (text == null) {
            text = "";
        }
        if ((tags = (xmlParser = new XmlParser()).parse(text.toString())) != null) {
            this.setText((CharSequence)this.buidSpannableString(tags));
        } else {
            super.setText(text, type);
        }
    }

    SpannableStringBuilder buidSpannableString(List<Tag> tags) {
        StringBuffer buffer = new StringBuffer();
        int bufferLength = 0;
        for (Tag tag : tags) {
            if (TextUtils.isEmpty((CharSequence)tag.getValue())) continue;
            buffer.append(tag.getValue());
            tag.setScope(bufferLength, bufferLength + tag.getValue().length());
            bufferLength += tag.getValue().length();
        }
        SpannableStringBuilder spannableString = new SpannableStringBuilder((CharSequence)buffer.toString());
        for (Tag tag : tags) {
            for (Object span : tag.buildSpan()) {
                spannableString.setSpan(span, tag.getStart(), tag.getEnd(), 33);
            }
        }
        return spannableString;
    }
}

