/*
 * Decompiled with CFR 0.152.
 */
package com.fjwangjia.android.richfonttextview;

import android.content.Context;
import android.text.SpannableStringBuilder;
import android.util.AttributeSet;
import android.widget.TextView;
import com.fjwangjia.android.richfonttextview.tag.Tag;
import com.fjwangjia.android.richfonttextview.xml.XmlParser;
import java.util.List;

public class RichFontTextView
extends TextView {
    public RichFontTextView(Context context) {
        super(context);
    }

    public RichFontTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public RichFontTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void setText(CharSequence text, TextView.BufferType type) {
        if (TextView.BufferType.SPANNABLE == type) {
            super.setText(text, type);
            return;
        }
        if (text == null) {
            return;
        }
        XmlParser xmlParser = new XmlParser();
        List<Tag> tags = xmlParser.parse(text.toString());
        if (tags != null) {
            this.setText((CharSequence)this.buidSpannableString(tags));
        } else {
            super.setText(text, type);
        }
    }

    SpannableStringBuilder buidSpannableString(List<Tag> tags) {
        StringBuffer buffer = new StringBuffer();
        int bufferLength = 0;
        for (Tag tag : tags) {
            buffer.append(tag.getValue());
            tag.setScope(bufferLength, bufferLength + tag.getValue().length());
            bufferLength += tag.getValue().length();
        }
        SpannableStringBuilder spannableString = new SpannableStringBuilder((CharSequence)buffer.toString());
        for (Tag tag : tags) {
            for (Object span : tag.buildSpan()) {
                spannableString.setSpan(span, tag.getStart(), tag.getEnd(), 33);
            }
        }
        return spannableString;
    }
}

