/*
 * Decompiled with CFR 0.152.
 */
package com.fjwangjia.android.richfonttextview.tag;

import android.text.style.AbsoluteSizeSpan;
import android.text.style.BackgroundColorSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.StyleSpan;
import android.text.style.SubscriptSpan;
import android.text.style.SuperscriptSpan;
import android.text.style.TypefaceSpan;
import android.text.style.UnderlineSpan;
import com.fjwangjia.android.richfonttextview.tag.Tag;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Font
extends Tag {
    private String size;
    private String color;
    private String style;
    private String typeface;
    private String line;
    private String script;
    private String background;

    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public String getColor() {
        return this.color;
    }

    public void setColor(String color) {
        this.color = color;
    }

    @Override
    public List<Object> buildSpan() {
        Method[] methods;
        this.spans.clear();
        for (Method method : methods = this.getClass().getDeclaredMethods()) {
            if (!method.getName().contains("build") || method.getName().equals("buildSpan")) continue;
            try {
                method.invoke((Object)this, new Object[0]);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return this.spans;
    }

    void buildSize() {
        if (this.size != null) {
            if (this.size.contains("px")) {
                int fontSize = Integer.valueOf(this.size.replace("px", ""));
                AbsoluteSizeSpan span = new AbsoluteSizeSpan(fontSize, false);
                this.spans.add(span);
            } else {
                String regEx = "[^0-9]";
                Pattern p = Pattern.compile(regEx);
                Matcher m = p.matcher(this.size);
                int fontSize = Integer.valueOf(m.replaceAll("").toString());
                AbsoluteSizeSpan span = new AbsoluteSizeSpan(fontSize, true);
                this.spans.add(span);
            }
        }
    }

    void buildColor() {
        if (this.color != null) {
            int fontColor = Integer.decode("0x" + this.color.replace("#", "").toString());
            ForegroundColorSpan colorSpan = new ForegroundColorSpan(0xFF000000 | fontColor);
            this.spans.add(colorSpan);
        }
    }

    void buildBackColor() {
        if (this.background != null) {
            int fontColor = Integer.decode("0x" + this.background.replace("#", "").toString());
            BackgroundColorSpan colorSpan = new BackgroundColorSpan(0xFF000000 | fontColor);
            this.spans.add(colorSpan);
        }
    }

    void buildSytle() {
        if (this.style != null) {
            int type = 0;
            switch (this.style) {
                case "n": 
                case "normal": {
                    break;
                }
                case "i": 
                case "italic": {
                    type = 2;
                    break;
                }
                case "b": 
                case "bold": {
                    type = 1;
                    break;
                }
                case "bi": 
                case "bold-italic": {
                    type = 3;
                }
            }
            StyleSpan styleSpan = new StyleSpan(type);
            this.spans.add(styleSpan);
        }
    }

    void buildTypeFace() {
        if (this.typeface != null) {
            TypefaceSpan typefaceSpan = new TypefaceSpan("default");
            this.spans.add(typefaceSpan);
        }
    }

    void buildLine() {
        if (this.line != null) {
            if (this.line.contains("del")) {
                this.spans.add(new StrikethroughSpan());
            }
            if (this.line.contains("under")) {
                this.spans.add(new UnderlineSpan());
            }
        }
    }

    void buildScript() {
        if (this.script != null) {
            if (this.script.equals("down") || this.script.equals("sub")) {
                this.spans.add(new SubscriptSpan());
            } else {
                this.spans.add(new SuperscriptSpan());
            }
        }
    }
}

