/*
 * Decompiled with CFR 0.152.
 */
package com.jerome.lib_base.theme;

import android.graphics.Color;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.TextView;
import com.google.android.material.tabs.TabLayout;
import com.jerome.lib_base.theme.Theme;

public class ThemeViewHelper {
    private static Theme theme;

    public static void handle(View view, Theme theme) {
        ThemeViewHelper.theme = theme;
        if (view.getTag() == null) {
            return;
        }
        if (view instanceof Button && !(view instanceof CheckBox)) {
            ThemeViewHelper.btn((Button)view);
            return;
        }
        if (view instanceof TextView) {
            ThemeViewHelper.textColor((TextView)view);
            ThemeViewHelper.textSize((TextView)view);
            return;
        }
    }

    private static void textColor(TextView view) {
        String tag = (String)view.getTag();
        view.setTextColor(Color.parseColor((String)theme.getTextColor()));
        if (tag.contains("mainColor")) {
            view.setTextColor(Color.parseColor((String)theme.getThemeMainColor()));
        }
    }

    private static void btn(Button btn) {
        ThemeViewHelper.textSize((TextView)btn);
        btn.setTextColor(Color.parseColor((String)theme.getBtnTextColor()));
        btn.setBackgroundColor(Color.parseColor((String)theme.getThemeMainColor()));
    }

    private static void textSize(TextView view) {
        String tag = (String)view.getTag();
        if (tag.contains("small")) {
            view.setTextSize(13.0f);
            return;
        }
        if (tag.contains("title")) {
            view.setTextSize(20.0f);
            return;
        }
        view.setTextSize(17.0f);
    }

    public static void handleViewGroup(ViewGroup viewGroup, Theme theme) {
        if (viewGroup instanceof TabLayout) {
            TabLayout layout = (TabLayout)viewGroup;
            layout.setBackgroundColor(Color.parseColor((String)theme.getThemeMainColor()));
        }
    }
}

