/*
 * Decompiled with CFR 0.152.
 */
package com.jerome.lib_base.theme;

import android.graphics.Color;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.MutableLiveData;
import androidx.recyclerview.widget.RecyclerView;
import com.blankj.utilcode.util.LogUtils;
import com.bumptech.glide.request.SingleRequest;
import com.google.android.material.tabs.TabLayout;
import com.jerome.lib_base.theme.IThemeListener;
import com.jerome.lib_base.theme.Theme;
import com.jerome.lib_base.theme.ThemeViewHelper;

public class ThemeGlobal {
    private static final MutableLiveData<Theme> HOLDER_LIVE_DATA = new MutableLiveData();
    private static Theme currTheme = Theme.NORMAL_THEME;

    public static MutableLiveData<Theme> getHolderLiveData() {
        return HOLDER_LIVE_DATA;
    }

    public static void setView(Fragment fragment, View v) {
        LifecycleOwner viewLifecycleOwner = fragment.getViewLifecycleOwner();
        HOLDER_LIVE_DATA.observe(viewLifecycleOwner, theme -> {
            currTheme = theme;
            ThemeGlobal.initStatu(fragment);
            if (fragment instanceof IThemeListener) {
                IThemeListener listener = (IThemeListener)fragment;
                listener.themeUi(currTheme);
            }
            if (theme != null) {
                new ViewHolder(v, (Theme)((Object)theme));
            }
        });
    }

    private static void initStatu(Fragment fragment) {
        Window window = fragment.getActivity().getWindow();
        View decorView = window.getDecorView();
        decorView.setSystemUiVisibility(1280);
        window.addFlags(Integer.MIN_VALUE);
        window.clearFlags(0x4000000);
        window.setStatusBarColor(Color.parseColor((String)currTheme.getThemeMainColor()));
    }

    public static Theme getCurrTheme() {
        return currTheme;
    }

    static class ViewHolder {
        private final String[] prefixStr = new String[]{"theme", "theme_"};
        private final String suffix = "end";
        private Theme theme;

        ViewHolder(View view, @NonNull Theme theme) {
            this.theme = theme;
            this.renderView(view);
        }

        private void renderView(View view) {
            if (view instanceof ViewGroup) {
                this.viewGroupTheme(view);
                ViewGroup group = (ViewGroup)view;
                for (int i = 0; i < group.getChildCount(); ++i) {
                    View childAt = group.getChildAt(i);
                    this.renderView(childAt);
                }
                return;
            }
            ThemeViewHelper.handle(view, this.theme);
            this.tagClear(view);
        }

        private void viewGroupTheme(View view) {
            if (view instanceof RecyclerView) {
                final RecyclerView recyclerView = (RecyclerView)view;
                recyclerView.addOnChildAttachStateChangeListener(new RecyclerView.OnChildAttachStateChangeListener(){

                    public void onChildViewAttachedToWindow(@NonNull View view) {
                        int childCount = recyclerView.getChildCount();
                        for (int i = 0; i < childCount; ++i) {
                            View childAt = recyclerView.getChildAt(i);
                            this.renderView(childAt);
                        }
                    }

                    public void onChildViewDetachedFromWindow(@NonNull View view) {
                    }
                });
                return;
            }
            String tag = (String)view.getTag();
            if (tag == null || !tag.contains(this.prefixStr[0]) && !tag.contains(this.prefixStr[1])) {
                return;
            }
            LogUtils.d((Object[])new Object[]{view + " --------- " + tag});
            if (view instanceof TabLayout) {
                ThemeViewHelper.handleViewGroup((ViewGroup)view, this.theme);
            }
            this.tagClear(view);
        }

        private void tagClear(View view) {
            Object tag = view.getTag();
            if (tag instanceof SingleRequest) {
                return;
            }
            if (tag == null) {
                return;
            }
            String strTag = (String)tag;
            for (String s : this.prefixStr) {
                if (!strTag.startsWith(s)) continue;
                if ((strTag = strTag.replace(s, "")).contains("end")) {
                    int i = strTag.indexOf("end");
                    strTag = strTag.substring(i);
                }
                LogUtils.d((Object[])new Object[]{view.getClass().getSimpleName() + " : tag \u53d8\u66f4\u4e3a : " + strTag});
                view.setTag((Object)strTag);
            }
        }
    }
}

