/*
 * Decompiled with CFR 0.152.
 */
package com.jerome.lib_base.navigator;

import android.content.ComponentName;
import android.os.Bundle;
import androidx.fragment.app.Fragment;
import androidx.navigation.ActivityNavigator;
import androidx.navigation.NavArgument;
import androidx.navigation.NavController;
import androidx.navigation.NavDestination;
import androidx.navigation.NavGraph;
import androidx.navigation.NavGraphNavigator;
import androidx.navigation.Navigator;
import androidx.navigation.NavigatorProvider;
import androidx.navigation.fragment.FragmentNavigator;
import com.blankj.utilcode.util.LogUtils;
import com.blankj.utilcode.util.ObjectUtils;
import com.jerome.lib_base.app.AppGlobals;
import com.jerome.lib_base.navigator.Destination;
import com.jerome.lib_base.navigator.FixFragmentNavigator;
import java.util.HashMap;
import java.util.Map;

public class NavGraphBuilder {
    private NavController navController;
    private Fragment fragment;
    private static NavGraphBuilder BUILDER;
    private NavigatorProvider navigatorProvider;
    private NavGraph navGraph;
    private FixFragmentNavigator fragmentNavigator;
    private ActivityNavigator activityNavigator;
    private int containerId;

    private NavGraphBuilder() {
    }

    public static void destory() {
        BUILDER = null;
    }

    private static NavGraphBuilder getInstance(Build build) {
        if (BUILDER != null) {
            build.setNavController(NavGraphBuilder.BUILDER.navController);
        } else {
            BUILDER = BuildHolder.BUILDER;
            BUILDER.setNavController(build.navController);
            BUILDER.setFragment(build.fragment);
            BUILDER.setContainerId(build.fragment.getId());
        }
        BUILDER.initProvider();
        BUILDER.initNavigator();
        BUILDER.initNavGraph();
        BUILDER.addDes(build.destinationHashMap);
        BUILDER.create();
        return BUILDER;
    }

    private void create() {
        this.navController.setGraph(this.navGraph);
    }

    private void initNavigator() {
        this.fragmentNavigator = new FixFragmentNavigator(this.fragment.getContext(), this.fragment.getChildFragmentManager(), this.containerId);
        this.activityNavigator = (ActivityNavigator)this.navigatorProvider.getNavigator(ActivityNavigator.class);
        this.navigatorProvider.addNavigator((Navigator)this.fragmentNavigator);
        this.navigatorProvider.addNavigator((Navigator)this.activityNavigator);
    }

    private void initNavGraph() {
        this.navGraph = new NavGraph((Navigator)new NavGraphNavigator(this.navigatorProvider));
    }

    private void initProvider() {
        this.navigatorProvider = this.navController.getNavigatorProvider();
    }

    public Fragment getFragment() {
        return this.fragment;
    }

    public void setFragment(Fragment fragment) {
        this.fragment = fragment;
    }

    public NavController getNavController() {
        return this.navController;
    }

    public void setNavController(NavController navController) {
        this.navController = navController;
    }

    public int getContainerId() {
        return this.containerId;
    }

    public void setContainerId(int containerId) {
        this.containerId = containerId;
    }

    public void addDes(HashMap<String, Destination> destinationHashMap) {
        if (ObjectUtils.isEmpty(destinationHashMap)) {
            return;
        }
        for (Map.Entry<String, Destination> entry : destinationHashMap.entrySet()) {
            FragmentNavigator.Destination destination;
            boolean needLogin;
            boolean isStart;
            int id;
            String url;
            String clazzName;
            Destination value = entry.getValue();
            LogUtils.d((Object[])new Object[]{"\u6dfb\u52a0\u8282\u70b9 : " + value.getClazzName()});
            if (value.isIsFragment()) {
                clazzName = value.getClazzName();
                url = value.getUrl();
                id = value.getId();
                isStart = value.isIsStart();
                needLogin = value.isNeedLogin();
                destination = this.fragmentNavigator.createDestination();
                destination.setClassName(clazzName);
                destination.setId(id);
                destination.addDeepLink(url);
                this.navGraph.addDestination((NavDestination)destination);
            } else {
                clazzName = value.getClazzName();
                url = value.getUrl();
                id = value.getId();
                isStart = value.isIsStart();
                needLogin = value.isNeedLogin();
                destination = this.activityNavigator.createDestination();
                destination.setId(id);
                destination.addDeepLink(url);
                destination.setComponentName(new ComponentName(AppGlobals.getApplication().getPackageName(), clazzName));
                this.navGraph.addDestination((NavDestination)destination);
            }
            int startDestination = this.navGraph.getStartDestination();
            if (!value.isIsStart() || startDestination != 0) continue;
            this.navGraph.setStartDestination(value.getId());
        }
    }

    public static int getId(String url) {
        return Math.abs(url.hashCode());
    }

    public static void navigate(String url, Fragment newInstance) {
        NavGraphBuilder.navigate(url, newInstance, false);
    }

    public static void navigate(String url, Fragment newInstance, boolean add) {
        int id = NavGraphBuilder.getId(url);
        Bundle arguments = newInstance.getArguments();
        if (arguments == null) {
            arguments = new Bundle();
        }
        NavArgument build = new NavArgument.Builder().setDefaultValue((Object)add).build();
        BUILDER.getNavController().getCurrentDestination().addArgument("AG_ADD", build);
        BUILDER.getNavController().navigate(id, arguments);
    }

    public static void navigateUp() {
        BUILDER.getNavController().navigateUp();
    }

    public static class Build {
        private Fragment fragment;
        private NavController navController;
        private HashMap<String, Destination> destinationHashMap;

        public Build(Fragment fragment, NavController navController, HashMap<String, Destination> destinationHashMap) {
            this.fragment = fragment;
            this.navController = navController;
            this.destinationHashMap = destinationHashMap;
        }

        public Fragment getFragment() {
            return this.fragment;
        }

        public Build setFragment(Fragment fragment) {
            this.fragment = fragment;
            return this;
        }

        public HashMap<String, Destination> getDestinationHashMap() {
            return this.destinationHashMap;
        }

        public Build setDestinationHashMap(HashMap<String, Destination> destinationHashMap) {
            if (!ObjectUtils.isEmpty(this.destinationHashMap)) {
                this.destinationHashMap.putAll(destinationHashMap);
            } else {
                this.destinationHashMap = destinationHashMap;
            }
            return this;
        }

        public NavController getNavController() {
            return this.navController;
        }

        public Build setNavController(NavController navController) {
            this.navController = navController;
            return this;
        }

        public NavGraphBuilder build() {
            return NavGraphBuilder.getInstance(this);
        }
    }

    private static class BuildHolder {
        private static final NavGraphBuilder BUILDER = new NavGraphBuilder();

        private BuildHolder() {
        }
    }
}

