/*
 * Decompiled with CFR 0.152.
 */
package com.jerome.lib_base.navigator;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import androidx.navigation.NavArgument;
import androidx.navigation.NavDestination;
import androidx.navigation.NavOptions;
import androidx.navigation.Navigator;
import androidx.navigation.fragment.FragmentNavigator;
import com.blankj.utilcode.util.LogUtils;
import com.jerome.lib_base.theme.ThemeGlobal;
import java.lang.reflect.Field;
import java.util.ArrayDeque;
import java.util.Map;

@Navigator.Name(value="fixfragment")
public class FixFragmentNavigator
extends FragmentNavigator {
    private static final String TAG = "FixFragmentNavigator";
    public static final String AG_ADD = "AG_ADD";
    private Context mContext;
    private FragmentManager mManager;
    private int mContainerId;
    private FragmentManager.FragmentLifecycleCallbacks callBack = new FragmentManager.FragmentLifecycleCallbacks(){

        public void onFragmentViewCreated(@NonNull FragmentManager fm, @NonNull Fragment f, @NonNull View v, @Nullable Bundle savedInstanceState) {
            super.onFragmentViewCreated(fm, f, v, savedInstanceState);
            ThemeGlobal.setView(f, f.getView());
        }

        public void onFragmentResumed(@NonNull FragmentManager fm, @NonNull Fragment f) {
            super.onFragmentResumed(fm, f);
        }

        public void onFragmentDestroyed(@NonNull FragmentManager fm, @NonNull Fragment f) {
            super.onFragmentDestroyed(fm, f);
            FixFragmentNavigator.this.mManager.unregisterFragmentLifecycleCallbacks(FixFragmentNavigator.this.callBack);
        }
    };

    public FixFragmentNavigator(@NonNull Context context, @NonNull FragmentManager manager, int containerId) {
        super(context, manager, containerId);
        this.mContext = context;
        this.mManager = manager;
        this.mContainerId = containerId;
    }

    @Nullable
    public NavDestination navigate(@NonNull FragmentNavigator.Destination destination, @Nullable Bundle args, @Nullable NavOptions navOptions, @Nullable Navigator.Extras navigatorExtras) {
        boolean isAdded;
        boolean isSingleTopReplacement;
        Fragment fragment;
        int popExitAnim;
        if (this.mManager.isStateSaved()) {
            Log.i((String)TAG, (String)"Ignoring navigate() call: FragmentManager has already saved its state");
            return null;
        }
        String className = destination.getClassName();
        if (className.charAt(0) == '.') {
            className = this.mContext.getPackageName() + className;
        }
        this.mManager.registerFragmentLifecycleCallbacks(this.callBack, true);
        FragmentTransaction ft = this.mManager.beginTransaction();
        int enterAnim = navOptions != null ? navOptions.getEnterAnim() : -1;
        int exitAnim = navOptions != null ? navOptions.getExitAnim() : -1;
        int popEnterAnim = navOptions != null ? navOptions.getPopEnterAnim() : -1;
        int n = popExitAnim = navOptions != null ? navOptions.getPopExitAnim() : -1;
        if (enterAnim != -1 || exitAnim != -1 || popEnterAnim != -1 || popExitAnim != -1) {
            enterAnim = enterAnim != -1 ? enterAnim : 0;
            exitAnim = exitAnim != -1 ? exitAnim : 0;
            popEnterAnim = popEnterAnim != -1 ? popEnterAnim : 0;
            popExitAnim = popExitAnim != -1 ? popExitAnim : 0;
            ft.setCustomAnimations(enterAnim, exitAnim, popEnterAnim, popExitAnim);
        }
        if ((fragment = this.mManager.getPrimaryNavigationFragment()) != null) {
            ft.hide(fragment);
        }
        String tag = String.valueOf(destination.getId());
        Fragment frag = this.mManager.findFragmentByTag(tag);
        boolean add = false;
        Map destinationArguments = destination.getArguments();
        NavArgument navArgument = (NavArgument)destinationArguments.get(AG_ADD);
        if (navArgument != null) {
            add = (Boolean)navArgument.getDefaultValue();
        }
        if (frag != null && !add) {
            LogUtils.e((Object[])new Object[]{"\u590d\u7528 :" + className + " -" + tag});
        } else {
            frag = this.instantiateFragment(this.mContext, this.mManager, className, args);
            frag.setArguments(args);
            ft.add(this.mContainerId, frag, tag);
            LogUtils.e((Object[])new Object[]{"\u65b0\u589e :" + className + " -" + tag});
        }
        ft.setPrimaryNavigationFragment(frag);
        int destId = destination.getId();
        ArrayDeque mBackStack = null;
        try {
            Field field = FragmentNavigator.class.getDeclaredField("mBackStack");
            field.setAccessible(true);
            mBackStack = (ArrayDeque)field.get((Object)this);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        boolean initialNavigation = mBackStack.isEmpty();
        boolean bl = isSingleTopReplacement = navOptions != null && !initialNavigation && navOptions.shouldLaunchSingleTop() && (Integer)mBackStack.peekLast() == destId;
        if (initialNavigation) {
            isAdded = true;
        } else if (isSingleTopReplacement) {
            if (mBackStack.size() > 1) {
                this.mManager.popBackStack(this.generateBackStackName(mBackStack.size(), (Integer)mBackStack.peekLast()), 1);
                ft.addToBackStack(this.generateBackStackName(mBackStack.size(), destId));
            }
            isAdded = false;
        } else {
            ft.addToBackStack(this.generateBackStackName(mBackStack.size() + 1, destId));
            isAdded = true;
        }
        if (navigatorExtras instanceof FragmentNavigator.Extras) {
            FragmentNavigator.Extras extras = (FragmentNavigator.Extras)navigatorExtras;
            for (Map.Entry sharedElement : extras.getSharedElements().entrySet()) {
                ft.addSharedElement((View)sharedElement.getKey(), (String)sharedElement.getValue());
            }
        }
        ft.setReorderingAllowed(true);
        ft.commit();
        if (isAdded) {
            mBackStack.add(destId);
            return destination;
        }
        return null;
    }

    private String generateBackStackName(int backStackindex, int destid) {
        return backStackindex + "-" + destid;
    }
}

