package com.jerome.lib_base.theme;

import android.graphics.Color;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.TextView;

import com.google.android.material.tabs.TabLayout;

/**
 * @author Created by 付俊杰
 * email:1025461682@qq.com
 * phone:17684220995
 * 2020/4/30 4:32 AM
 */
public class ThemeViewHelper {
    private static Theme theme;

    public static void handle(View view, Theme theme) {
        ThemeViewHelper.theme = theme;
        if (view.getTag() == null) {
            return;
        }
        //按钮也继承自TextView,所以必须放前面
        if (view instanceof Button && !(view instanceof CheckBox)) {
            btn((Button) view);
            return;
        }
        //文本情况
        if (view instanceof TextView) {
            //文字颜色
            textColor((TextView) view);
            textSize((TextView) view);
            return;
        }
    }

    /**
     * 文本颜色
     */
    private static void textColor(TextView view) {
        String tag = (String) view.getTag();
        view.setTextColor(Color.parseColor(theme.getTextColor()));
        if (tag.contains("mainColor")) {
            view.setTextColor(Color.parseColor(theme.getThemeMainColor()));
        }
    }

    /**
     * 按钮情况
     */
    private static void btn(Button btn) {
        textSize(btn);
        btn.setTextColor(Color.parseColor(theme.getBtnTextColor()));
        btn.setBackgroundColor(Color.parseColor(theme.getThemeMainColor()));
    }

    /**
     * 字体大小处理方案
     */
    private static void textSize(TextView view) {
        //字体处理
        String tag = (String) view.getTag();
        if (tag.contains("small")) {
            view.setTextSize(Theme.TEXT_SZIE_SMALL);
            return;
        }
        if (tag.contains("title")) {
            view.setTextSize(Theme.TEXT_SZIE_TITLE);
            return;
        }
        view.setTextSize(Theme.TEXT_SZIE_NORMAL);
    }

    public static void handleViewGroup(ViewGroup viewGroup, Theme theme) {
        if (viewGroup instanceof TabLayout) {
            TabLayout layout = (TabLayout) viewGroup;
            layout.setBackgroundColor(Color.parseColor(theme.getThemeMainColor()));
        }
    }
}
