package com.jerome.lib_base.theme;

import android.graphics.Color;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;

import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.MutableLiveData;
import androidx.recyclerview.widget.RecyclerView;

import com.blankj.utilcode.util.LogUtils;
import com.bumptech.glide.request.SingleRequest;
import com.google.android.material.tabs.TabLayout;

/**
 * @author Created by 付俊杰
 * email:1025461682@qq.com
 * phone:17684220995
 * 2020/4/29 7:14 PM
 */
public class ThemeGlobal {
    private static final MutableLiveData<Theme> HOLDER_LIVE_DATA = new MutableLiveData<>();

    public static MutableLiveData<Theme> getHolderLiveData() {
        return HOLDER_LIVE_DATA;
    }

    private static Theme currTheme = Theme.NORMAL_THEME;

    public static void setView(Fragment fragment, View v) {
        LifecycleOwner viewLifecycleOwner = fragment.getViewLifecycleOwner();
        HOLDER_LIVE_DATA.observe(viewLifecycleOwner, theme -> {
            currTheme = theme;
            //状态栏处理
            initStatu(fragment);
            if (fragment instanceof IThemeListener) {
                IThemeListener listener = (IThemeListener) fragment;
                listener.themeUi(currTheme);
            }
            if (theme != null) {
                //更改控件
                new ViewHolder(v, theme);
            }
        });
    }

    private static void initStatu(Fragment fragment) {
        Window window = fragment.getActivity().getWindow();
        View decorView = window.getDecorView();
        decorView.setSystemUiVisibility(View.SYSTEM_UI_FLAG_LAYOUT_FULLSCREEN
                | View.SYSTEM_UI_FLAG_LAYOUT_STABLE);
        window.addFlags(WindowManager.LayoutParams.FLAG_DRAWS_SYSTEM_BAR_BACKGROUNDS);
        window.clearFlags(WindowManager.LayoutParams.FLAG_TRANSLUCENT_STATUS);
        window.setStatusBarColor(Color.parseColor(currTheme.getThemeMainColor()));
    }

    public static Theme getCurrTheme() {
        return currTheme;
    }

    /**
     * 控件处理类
     */
    static class ViewHolder {
        private final String[] prefixStr = {
                "theme",
                "theme_"
        };
        private final String suffix = "end";
        private Theme theme;

        ViewHolder(View view, @NonNull Theme theme) {
            this.theme = theme;
            //对view进行主题加工
            renderView(view);
        }


        /**
         * 渲染视图
         */
        private void renderView(View view) {
            if (view instanceof ViewGroup) {
                viewGroupTheme(view);
                ViewGroup group = (ViewGroup) view;
                for (int i = 0; i < group.getChildCount(); i++) {
                    View childAt = group.getChildAt(i);
                    renderView(childAt);
                }
                return;
            }
            //通过tag处理
            ThemeViewHelper.handle(view, theme);
            //最后将tag处理一下，避免其它控件后续用到
            tagClear(view);
        }

        private void viewGroupTheme(View view) {
            if (view instanceof RecyclerView) {
                RecyclerView recyclerView = (RecyclerView) view;
                recyclerView.addOnChildAttachStateChangeListener(new RecyclerView.OnChildAttachStateChangeListener() {
                    @Override
                    public void onChildViewAttachedToWindow(@NonNull View view) {
                        int childCount = recyclerView.getChildCount();
                        for (int i = 0; i < childCount; i++) {
                            View childAt = recyclerView.getChildAt(i);
                            renderView(childAt);
                        }
                    }

                    @Override
                    public void onChildViewDetachedFromWindow(@NonNull View view) {

                    }
                });
                return;
            }

            String tag = (String) view.getTag();
            if (tag == null || (!tag.contains(prefixStr[0]) && !tag.contains(prefixStr[1]))) {
                return;
            }
            LogUtils.d(view + " --------- " + tag);
            if (view instanceof TabLayout) {
                ThemeViewHelper.handleViewGroup((ViewGroup) view, theme);
            }
            tagClear(view);
        }

        private void tagClear(View view) {
            Object tag = view.getTag();
            if (tag instanceof SingleRequest) {
                return;
            }
            if (tag == null) {
                return;
            }
            String strTag = (String) tag;
            for (String s : prefixStr) {
                if (strTag.startsWith(s)) {
                    strTag = strTag.replace(s, "");
                    if (strTag.contains(suffix)) {
                        int i = strTag.indexOf(suffix);
                        strTag = strTag.substring(i);
                    }
                    LogUtils.d(view.getClass().getSimpleName() + " : tag 变更为 : " + strTag);
                    view.setTag(strTag);
                }
            }
        }
    }
}
