package com.jerome.lib_base.navigator;

import android.content.ComponentName;
import android.os.Bundle;

import androidx.fragment.app.Fragment;
import androidx.navigation.ActivityNavigator;
import androidx.navigation.NavArgument;
import androidx.navigation.NavController;
import androidx.navigation.NavGraph;
import androidx.navigation.NavGraphNavigator;
import androidx.navigation.NavigatorProvider;
import androidx.navigation.fragment.FragmentNavigator;

import com.blankj.utilcode.util.LogUtils;
import com.blankj.utilcode.util.ObjectUtils;
import com.jerome.lib_base.app.AppGlobals;

import java.util.HashMap;
import java.util.Map;

/**
 * @author Created by 付俊杰
 * email:1025461682@qq.com
 * phone:17684220995
 * 2020/5/2 2:20 PM
 */
public class NavGraphBuilder {
    private NavController navController;
    private Fragment fragment;

    private static NavGraphBuilder BUILDER;
    private NavigatorProvider navigatorProvider;
    private NavGraph navGraph;
    private FixFragmentNavigator fragmentNavigator;
    private ActivityNavigator activityNavigator;
    private int containerId;

    private NavGraphBuilder() {

    }

    public static void destory() {
        BUILDER = null;
    }

    private static class BuildHolder {
        private static final NavGraphBuilder BUILDER = new NavGraphBuilder();
    }

    /**
     * 因为每个模块主要的activity都会继承抽象的base activity,而每个base activity都会自然而然的去使用本类，那么必定会走这个方法，为了保证单一性等，只有在这里做一些手脚去处理节点的关系
     */
    private static NavGraphBuilder getInstance(Build build) {
        if (BUILDER != null) {
            build.setNavController(BUILDER.navController);
        } else {
            BUILDER = BuildHolder.BUILDER;
            BUILDER.setNavController(build.navController);
            BUILDER.setFragment(build.fragment);
            BUILDER.setContainerId(build.fragment.getId());
        }
        BUILDER.initProvider();
        BUILDER.initNavigator();
        BUILDER.initNavGraph();
        BUILDER.addDes(build.destinationHashMap);
        BUILDER.create();
        return BUILDER;
    }

    private void create() {
        navController.setGraph(navGraph);
    }

    private void initNavigator() {
        fragmentNavigator = new FixFragmentNavigator(fragment.getContext(), fragment.getChildFragmentManager(), containerId);
        activityNavigator = navigatorProvider.getNavigator(ActivityNavigator.class);
        navigatorProvider.addNavigator(fragmentNavigator);
        navigatorProvider.addNavigator(activityNavigator);
    }

    private void initNavGraph() {
        //这里创建NavGraph,这样就完全抛弃了xml的那个东东
        navGraph = new NavGraph(new NavGraphNavigator(navigatorProvider));
    }

    private void initProvider() {
        navigatorProvider = navController.getNavigatorProvider();
    }

    public Fragment getFragment() {
        return fragment;
    }

    public void setFragment(Fragment fragment) {
        this.fragment = fragment;
    }

    public NavController getNavController() {
        return navController;
    }

    public void setNavController(NavController navController) {
        this.navController = navController;
    }

    public int getContainerId() {
        return containerId;
    }

    public void setContainerId(int containerId) {
        this.containerId = containerId;
    }

    public void addDes(HashMap<String, Destination> destinationHashMap) {
        if (ObjectUtils.isEmpty(destinationHashMap)) {
            return;
        }
        for (Map.Entry<String, Destination> entry : destinationHashMap.entrySet()) {
            Destination value = entry.getValue();
            LogUtils.d("添加节点 : " + value.getClazzName());
            if (value.isIsFragment()) {
                String clazzName = value.getClazzName();
                String url = value.getUrl();
                int id = value.getId();
                boolean isStart = value.isIsStart();
                boolean needLogin = value.isNeedLogin();

                FragmentNavigator.Destination destination = fragmentNavigator.createDestination();
                destination.setClassName(clazzName);
                destination.setId(id);
                destination.addDeepLink(url);

                navGraph.addDestination(destination);
            } else {
                String clazzName = value.getClazzName();
                String url = value.getUrl();
                int id = value.getId();
                boolean isStart = value.isIsStart();
                boolean needLogin = value.isNeedLogin();

                ActivityNavigator.Destination destination = activityNavigator.createDestination();
                destination.setId(id);
                destination.addDeepLink(url);
                destination.setComponentName(new ComponentName(AppGlobals.getApplication().getPackageName(), clazzName));

                navGraph.addDestination(destination);
            }
            int startDestination = navGraph.getStartDestination();
            if (value.isIsStart() && startDestination == 0) {
                navGraph.setStartDestination(value.getId());
            }
        }
    }

    public static class Build {
        private Fragment fragment;
        private NavController navController;
        private HashMap<String, Destination> destinationHashMap;

        public Build(Fragment fragment, NavController navController, HashMap<String, Destination> destinationHashMap) {
            this.fragment = fragment;
            this.navController = navController;
            this.destinationHashMap = destinationHashMap;
        }

        public Fragment getFragment() {
            return fragment;
        }

        public Build setFragment(Fragment fragment) {
            this.fragment = fragment;
            return this;
        }

        public HashMap<String, Destination> getDestinationHashMap() {
            return destinationHashMap;
        }

        public Build setDestinationHashMap(HashMap<String, Destination> destinationHashMap) {
            if (!ObjectUtils.isEmpty(this.destinationHashMap)) {
                this.destinationHashMap.putAll(destinationHashMap);
            } else {
                this.destinationHashMap = destinationHashMap;
            }
            return this;
        }

        public NavController getNavController() {
            return navController;
        }


        public Build setNavController(NavController navController) {
            this.navController = navController;
            return this;
        }

        public NavGraphBuilder build() {
            return NavGraphBuilder.getInstance(this);
        }
    }

    public static int getId(String url) {
        return Math.abs(url.hashCode());
    }

    public static void navigate(String url, Fragment newInstance) {
        navigate(url, newInstance, false);
    }

    public static void navigate(String url, Fragment newInstance, boolean add) {
        int id = getId(url);
        Bundle arguments = newInstance.getArguments();
        if (arguments == null) {
            arguments = new Bundle();
        }
        NavArgument build = new NavArgument.Builder().setDefaultValue(add).build();
        NavGraphBuilder.BUILDER.getNavController().getCurrentDestination().addArgument(FixFragmentNavigator.AG_ADD, build);
        NavGraphBuilder.BUILDER.getNavController().navigate(id, arguments);
    }

    public static void navigateUp() {
        NavGraphBuilder.BUILDER.getNavController().navigateUp();
    }
}
