/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.rocker.model;

import com.fizzed.rocker.antlr4.WithBlockLexer;
import com.fizzed.rocker.antlr4.WithBlockParser;
import com.fizzed.rocker.compiler.DescriptiveErrorListener;
import com.fizzed.rocker.compiler.ParserRuntimeException;
import com.fizzed.rocker.compiler.TemplateParser;
import com.fizzed.rocker.compiler.TokenException;
import com.fizzed.rocker.compiler.WithBlockParserListener;
import com.fizzed.rocker.model.JavaVariable;
import com.fizzed.rocker.model.NullSafety;
import java.util.ArrayList;
import java.util.List;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public class WithStatement
implements NullSafety {
    private static final WithBlockParserListener WITH_BLOCK_PARSER_LISTENER = new WithBlockParserListener();
    private final List<VariableWithExpression> variables;
    private final boolean nullSafe;

    public WithStatement(List<VariableWithExpression> variables) {
        this(variables, false);
    }

    public WithStatement(List<VariableWithExpression> variables, boolean nullSafe) {
        this.variables = variables;
        this.nullSafe = nullSafe;
    }

    public List<VariableWithExpression> getVariables() {
        return this.variables;
    }

    public boolean hasAnyVariableNullType() {
        for (VariableWithExpression v : this.variables) {
            if (v.getVariable().getType() != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isNullSafe() {
        return this.nullSafe;
    }

    public static WithStatement parse(String statement, String templatePath) throws TokenException {
        boolean nullSafe = false;
        if (statement.startsWith("?")) {
            nullSafe = true;
            statement = statement.substring(1).trim();
        }
        if (!statement.startsWith("(")) {
            throw new TokenException("With block does not start with parenthese");
        }
        if (!statement.endsWith(")")) {
            throw new TokenException("With block does not end with parenthese");
        }
        statement = statement.substring(1, statement.length() - 1);
        ArrayList<VariableWithExpression> variables = new ArrayList<VariableWithExpression>();
        List<String> withStatements = WithStatement.parseWithStatement(statement, templatePath);
        for (int i = 0; i < withStatements.size(); ++i) {
            String withStatement = withStatements.get(i);
            int equalsPos = withStatement.indexOf(61);
            if (equalsPos < 0) {
                throw new TokenException("With block invalid: no equals symbol found for assignment: " + withStatement);
            }
            if (withStatement.indexOf(61, equalsPos + 1) > 0) {
                throw new TokenException("With block invalid: multiple equals symbols found for assignment " + withStatement);
            }
            String varPart = withStatement.substring(0, equalsPos);
            JavaVariable variable = JavaVariable.parse(varPart);
            String valueExpression = withStatement.substring(equalsPos + 1).trim();
            if (valueExpression.equals("")) {
                throw new TokenException("With block contains an empty string for value part (e.g. var = value)");
            }
            variables.add(new VariableWithExpression(variable, valueExpression));
        }
        if (nullSafe && variables.size() > 1) {
            throw new TokenException("Nullsafe option not allowed for with block with multiple arguments");
        }
        return new WithStatement(variables, nullSafe);
    }

    private static List<String> parseWithStatement(String value, String templatePath) {
        WithBlockLexer lexer = new WithBlockLexer((CharStream)new ANTLRInputStream(value));
        lexer.removeErrorListeners();
        lexer.addErrorListener((ANTLRErrorListener)new DescriptiveErrorListener());
        try {
            CommonTokenStream in = new CommonTokenStream((TokenSource)lexer);
            WithBlockParser parser = new WithBlockParser((TokenStream)in);
            parser.removeErrorListeners();
            parser.addErrorListener((ANTLRErrorListener)new DescriptiveErrorListener());
            WithBlockParser.StartContext start = parser.start();
            WITH_BLOCK_PARSER_LISTENER.clear();
            ParseTreeWalker.DEFAULT.walk((ParseTreeListener)WITH_BLOCK_PARSER_LISTENER, (ParseTree)start);
            return WITH_BLOCK_PARSER_LISTENER.getArguments();
        }
        catch (ParserRuntimeException e) {
            throw TemplateParser.unwrapParserRuntimeException(templatePath, e);
        }
    }

    public static class VariableWithExpression {
        private final JavaVariable variable;
        private final String valueExpression;

        private VariableWithExpression(JavaVariable variable, String valueExpression) {
            this.variable = variable;
            this.valueExpression = valueExpression;
        }

        public JavaVariable getVariable() {
            return this.variable;
        }

        public String getValueExpression() {
            return this.valueExpression;
        }

        public String toString() {
            return "VariableWithExpression{variable=" + this.variable + ", valueExpression='" + this.valueExpression + '\'' + '}';
        }
    }
}

