/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.rocker.model;

import com.fizzed.rocker.ContentType;
import com.fizzed.rocker.compiler.RockerOptions;
import com.fizzed.rocker.compiler.RockerUtil;
import com.fizzed.rocker.model.Argument;
import com.fizzed.rocker.model.JavaImport;
import com.fizzed.rocker.model.PlainText;
import com.fizzed.rocker.model.TemplateUnit;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

public class TemplateModel {
    private final String packageName;
    private final String templateName;
    private final ContentType contentType;
    private final long modifiedAt;
    private final String name;
    private final List<JavaImport> imports;
    private final List<Argument> arguments;
    private final List<TemplateUnit> units;
    private final RockerOptions options;

    public TemplateModel(String packageName, String templateName, long modifiedAt, RockerOptions defaultOptions) {
        this.packageName = packageName;
        this.templateName = templateName;
        this.name = RockerUtil.templateNameToName(templateName);
        this.contentType = RockerUtil.templateNameToContentType(templateName);
        this.modifiedAt = modifiedAt;
        this.imports = new ArrayList<JavaImport>();
        this.arguments = new ArrayList<Argument>();
        this.units = new ArrayList<TemplateUnit>();
        this.options = defaultOptions;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public String getName() {
        return this.name;
    }

    public long getModifiedAt() {
        return this.modifiedAt;
    }

    public List<JavaImport> getImports() {
        return this.imports;
    }

    public List<Argument> getArguments() {
        return this.arguments;
    }

    public boolean hasRockerBodyArgument() {
        return this.getRockerBodyArgument() != null;
    }

    public Argument getRockerBodyArgument() {
        Argument lastArgument;
        if (!this.arguments.isEmpty() && (lastArgument = this.arguments.get(this.arguments.size() - 1)).getType().equals("RockerBody")) {
            return lastArgument;
        }
        return null;
    }

    public List<Argument> getArgumentsWithoutRockerBody() {
        if (this.hasRockerBodyArgument()) {
            return this.arguments.subList(0, this.arguments.size() - 1);
        }
        return this.arguments;
    }

    public RockerOptions getOptions() {
        return this.options;
    }

    public List<TemplateUnit> getUnits() {
        return this.units;
    }

    public <T extends TemplateUnit> T getUnit(int index, Class<T> type) {
        return (T)this.units.get(index);
    }

    public <T extends TemplateUnit> T findUnitByOccurrence(Class<T> type, int occurrence) {
        if (occurrence < 1) {
            throw new IllegalArgumentException("Occurrence needs to be >= 1");
        }
        int foundSoFar = 0;
        for (TemplateUnit unit : this.units) {
            if (type != unit.getClass() || ++foundSoFar != occurrence) continue;
            return (T)unit;
        }
        throw new RuntimeException("Failed to find occurrence: " + occurrence + " for TemplateUnit of type: " + type.getName());
    }

    public LinkedHashMap<String, LinkedHashMap<String, String>> createPlainTextMap(int chunkSize) {
        int index = 0;
        LinkedHashMap<String, LinkedHashMap<String, String>> plainTextMap = new LinkedHashMap<String, LinkedHashMap<String, String>>();
        for (TemplateUnit unit : this.getUnits()) {
            PlainText plain;
            if (!(unit instanceof PlainText) || plainTextMap.containsKey((plain = (PlainText)unit).getText())) continue;
            LinkedHashMap<String, String> chunkMap = new LinkedHashMap<String, String>();
            plainTextMap.put(plain.getText(), chunkMap);
            List<String> chunks = RockerUtil.stringIntoChunks(plain.getText(), chunkSize);
            for (int chunkIndex = 0; chunkIndex < chunks.size(); ++chunkIndex) {
                String varName = "PLAIN_TEXT_" + index + "_" + chunkIndex;
                String chunkText = chunks.get(chunkIndex);
                chunkMap.put(varName, chunkText);
            }
            ++index;
        }
        return plainTextMap;
    }

    public int createHeaderHash() {
        StringBuilder s = new StringBuilder();
        s.append(this.contentType);
        s.append(";");
        for (Argument arg : this.arguments) {
            s.append(arg.getType());
            s.append(" ");
            s.append(arg.getName());
            s.append(";");
        }
        return s.toString().hashCode();
    }
}

