/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.rocker.model;

import com.fizzed.rocker.compiler.RockerUtil;
import com.fizzed.rocker.compiler.TokenException;
import com.fizzed.rocker.model.SourcePosition;

public class SourceRef {
    private final SourcePosition begin;
    private final int charLength;
    private final String text;

    public SourceRef(SourcePosition begin, int charLength, String text) {
        this.begin = begin;
        this.charLength = charLength;
        this.text = text;
    }

    public SourceRef combineAdjacent(SourceRef other) throws TokenException {
        return new SourceRef(this.begin, this.charLength + other.charLength, this.text + other.text);
    }

    public SourcePosition getBegin() {
        return this.begin;
    }

    public int getCharLength() {
        return this.charLength;
    }

    public String getText() {
        return this.text;
    }

    public String getConsoleFriendlyText() {
        return RockerUtil.consoleFriendlyText(this.text);
    }

    public String toString() {
        return new StringBuilder(20).append(this.begin).append(" for ").append(this.charLength).append(" chars").toString();
    }
}

