/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.rocker.model;

import org.apache.commons.lang3.StringUtils;

public enum JavaVersion {
    v1_6(6, "1.6"),
    v1_7(7, "1.7"),
    v1_8(8, "1.8");

    private final int version;
    private final String label;

    private JavaVersion(int version, String label) {
        this.version = version;
        this.label = label;
    }

    public int getVersion() {
        return this.version;
    }

    public String getLabel() {
        return this.label;
    }

    public static JavaVersion findByLabel(String label) {
        if (StringUtils.isNumeric((CharSequence)label)) {
            return v1_8;
        }
        for (JavaVersion jv : JavaVersion.values()) {
            if (!jv.getLabel().equals(label)) continue;
            return jv;
        }
        return null;
    }

    public static String current() {
        return JavaVersion.toVersion(System.getProperty("java.version"));
    }

    public static String toVersion(String version) {
        if (version.startsWith("1.")) {
            return version.substring(0, 3);
        }
        int dotIndex = version.indexOf(46);
        int dashIndex = version.indexOf(45);
        return version.substring(0, dotIndex > -1 ? dotIndex : (dashIndex > -1 ? dashIndex : version.length()));
    }
}

