/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.rocker.compiler;

import com.fizzed.rocker.ContentType;
import com.fizzed.rocker.model.JavaVersion;
import com.fizzed.rocker.model.TemplateModel;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.text.translate.CharSequenceTranslator;
import org.apache.commons.lang3.text.translate.EntityArrays;
import org.apache.commons.lang3.text.translate.LookupTranslator;

public class RockerUtil {
    private static final Pattern VALID_JAVA_IDENTIFIER = Pattern.compile("\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*");
    public static final CharSequenceTranslator ESCAPE_JAVA = new LookupTranslator((CharSequence[][])new String[][]{{"\"", "\\\""}, {"\\", "\\\\"}}).with(new CharSequenceTranslator[]{new LookupTranslator((CharSequence[][])EntityArrays.JAVA_CTRL_CHARS_ESCAPE())});

    public static boolean isJava8Plus(TemplateModel model) {
        return model.getOptions().isGreaterThanOrEqualToJavaVersion(JavaVersion.v1_8);
    }

    public static boolean isJavaIdentifier(String identifier) {
        return VALID_JAVA_IDENTIFIER.matcher(identifier).matches();
    }

    public static String pathToPackageName(Path path) {
        if (path == null) {
            return "";
        }
        return path.toString().replace(File.separator, ".");
    }

    public static Path packageNameToPath(String packageName) {
        if (packageName == null || packageName.equals("")) {
            return null;
        }
        return Paths.get(packageName.replace('.', '/'), new String[0]);
    }

    public static boolean isRelativePath(Path baseDir, Path file) {
        return file.startsWith(baseDir);
    }

    public static int countChars(String value, char ch) {
        int count = 0;
        for (int i = 0; i < value.length(); ++i) {
            if (value.charAt(i) != ch) continue;
            ++count;
        }
        return count;
    }

    public static boolean isWhitespaceNoLineBreak(char c) {
        switch (c) {
            case '\t': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    public static boolean isWhitespace(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    public static boolean isWhitespace(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (RockerUtil.isWhitespace(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static String consoleFriendlyText(String s) {
        if (s == null) {
            return "<NULL>";
        }
        s = s.replace("\n", "\\n");
        s = s.replace("\r", "\\r");
        return s;
    }

    public static String templateNameToName(String templateName) {
        int pos = templateName.indexOf(46);
        if (pos < 1) {
            throw new IllegalArgumentException("Invalid template name format (unable find first dot character)");
        }
        return templateName.substring(0, pos);
    }

    public static ContentType templateNameToContentType(String templateName) {
        int pos = templateName.lastIndexOf(46);
        if (pos < 0) {
            throw new IllegalArgumentException("Invalid template name format (unable find last dot character)");
        }
        String ext = templateName.substring(pos + 1);
        for (ContentType type : ContentType.values()) {
            if (!type.toString().equalsIgnoreCase(ext)) continue;
            return type;
        }
        throw new IllegalArgumentException("Unsupported content type for extension [" + ext + "] for template name [" + templateName + "]");
    }

    public static Collection<File> listFileTree(File dir) {
        HashSet<File> fileTree = new HashSet<File>();
        for (File entry : dir.listFiles()) {
            if (entry.isFile()) {
                fileTree.add(entry);
                continue;
            }
            fileTree.addAll(RockerUtil.listFileTree(entry));
        }
        return fileTree;
    }

    public static String qualifiedClassName(Object obj) {
        return RockerUtil.qualifiedClassName(obj.getClass());
    }

    public static String qualifiedClassName(Class<?> type) {
        return type.getName().replace('$', '.');
    }

    public static String unqualifiedClassName(Object obj) {
        return RockerUtil.unqualifiedClassName(obj.getClass());
    }

    public static String unqualifiedClassName(Class<?> type) {
        String name = type.getName();
        if (name != null && name.lastIndexOf(46) > 0) {
            name = name.substring(name.lastIndexOf(46) + 1);
            name = name.replace('$', '.');
        }
        return name;
    }

    public static String chompClosureOpen(String expr) {
        if (!expr.endsWith("{")) {
            return expr;
        }
        int closurePos = expr.lastIndexOf("->");
        if (closurePos < 0) {
            return expr;
        }
        return expr.substring(0, closurePos).trim();
    }

    public static String chompClosureAssignmentOpen(String expr) {
        if (!expr.endsWith("{")) {
            return expr;
        }
        int closureAssignmentPos = expr.lastIndexOf("=>");
        if (closureAssignmentPos < 0) {
            return expr;
        }
        return expr.substring(0, closureAssignmentPos).trim();
    }

    public static List<String> stringIntoChunks(String s, int chunkSize) {
        int chunkLength;
        if (s.length() <= chunkSize) {
            return Arrays.asList(s);
        }
        ArrayList<String> strings = new ArrayList<String>();
        for (int offset = 0; offset < s.length(); offset += chunkLength) {
            chunkLength = chunkSize;
            if (offset + chunkLength > s.length()) {
                chunkLength = s.length() - offset;
            }
            String chunk = s.substring(offset, offset + chunkLength);
            strings.add(chunk);
        }
        return strings;
    }

    public static List<String> getTextAsJavaByteArrayInitializer(String text, String charsetName, int maxArraySize) throws UnsupportedEncodingException {
        byte[] bytes = text.getBytes(charsetName);
        ArrayList<String> arrays = new ArrayList<String>();
        int length = 0;
        while (length < bytes.length) {
            StringBuilder sb = new StringBuilder();
            sb.append("new byte[] { ");
            for (int chunk = 0; length < bytes.length && chunk < maxArraySize; ++length, ++chunk) {
                byte b = bytes[length];
                if (chunk != 0) {
                    sb.append(", ");
                }
                RockerUtil.appendByteAsJavaByteInitializer(sb, b);
                ++chunk;
            }
            sb.append(" };");
            arrays.add(sb.toString());
        }
        return arrays;
    }

    public static void appendByteAsJavaByteInitializer(StringBuilder sb, byte b) {
        if (b >= 0 && b < 128) {
            if (Character.isAlphabetic(b)) {
                sb.append("'").append((char)b).append("'");
            } else {
                sb.append("0x").append(RockerUtil.byteArrayToHex(new byte[]{b}));
            }
        } else {
            sb.append("(byte)0x").append(RockerUtil.byteArrayToHex(new byte[]{b}));
        }
    }

    public static String md5(File f) throws IOException {
        try {
            byte[] b = Files.readAllBytes(f.toPath());
            byte[] hash = MessageDigest.getInstance("MD5").digest(b);
            return RockerUtil.byteArrayToHex(hash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e.getMessage(), e);
        }
    }

    public static String byteArrayToHex(byte[] a) {
        StringBuilder sb = new StringBuilder(a.length * 2);
        for (byte b : a) {
            sb.append(String.format("%02x", b & 0xFF));
        }
        return sb.toString();
    }
}

