/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.rocker.compiler;

import com.fizzed.rocker.ContentType;
import com.fizzed.rocker.compiler.TemplateParser;
import com.fizzed.rocker.compiler.TokenException;
import com.fizzed.rocker.model.JavaVersion;
import com.fizzed.rocker.model.Option;
import com.fizzed.rocker.runtime.DefaultRockerModel;
import com.fizzed.rocker.runtime.DefaultRockerTemplate;
import com.fizzed.rocker.runtime.ParserException;
import java.nio.charset.Charset;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;

public class RockerOptions {
    public static final String JAVA_VERSION = "javaVersion";
    public static final String DISCARD_LOGIC_WHITESPACE = "discardLogicWhitespace";
    public static final String COMBINE_ADJACENT_PLAIN = "combineAdjacentPlain";
    public static final String EXTENDS_CLASS = "extendsClass";
    public static final String EXTENDS_MODEL_CLASS = "extendsModelClass";
    public static final String TARGET_CHARSET = "targetCharset";
    public static final String OPTIMIZE = "optimize";
    public static final String POST_PROCESSING = "postProcessing";
    public static final String MARK_AS_GENERATED = "markAsGenerated";
    private JavaVersion javaVersion = JavaVersion.v1_8;
    private Boolean discardLogicWhitespace = null;
    private Boolean combineAdjacentPlain = Boolean.TRUE;
    private String extendsClass = DefaultRockerTemplate.class.getName();
    private String extendsModelClass = DefaultRockerModel.class.getName();
    private String targetCharset = "UTF-8";
    private Boolean optimize = Boolean.FALSE;
    private String[] postProcessing = new String[0];
    private Boolean markAsGenerated = Boolean.FALSE;

    public RockerOptions copy() {
        RockerOptions options = new RockerOptions();
        options.javaVersion = this.javaVersion;
        options.discardLogicWhitespace = this.discardLogicWhitespace;
        options.combineAdjacentPlain = this.combineAdjacentPlain;
        options.extendsClass = this.extendsClass;
        options.extendsModelClass = this.extendsModelClass;
        options.targetCharset = this.targetCharset;
        options.optimize = this.optimize;
        options.postProcessing = new String[0];
        options.markAsGenerated = this.markAsGenerated;
        return options;
    }

    public JavaVersion getJavaVersion() {
        return this.javaVersion;
    }

    public boolean isGreaterThanOrEqualToJavaVersion(JavaVersion javaVersion) {
        return this.javaVersion.getVersion() >= javaVersion.getVersion();
    }

    public void setJavaVersion(JavaVersion javaVersion) {
        this.javaVersion = javaVersion;
    }

    public void setJavaVersion(String javaVersion) throws TokenException {
        if (javaVersion == null) {
            throw new TokenException("javaVersion was null");
        }
        JavaVersion jv = JavaVersion.findByLabel(javaVersion);
        if (jv == null) {
            throw new TokenException("Unsupported javaVersion [" + javaVersion + "]");
        }
        this.javaVersion = jv;
    }

    public Boolean getDiscardLogicWhitespace() {
        return this.discardLogicWhitespace;
    }

    public boolean getDiscardLogicWhitespaceForContentType(ContentType type) {
        if (this.discardLogicWhitespace == null) {
            return ContentType.discardLogicWhitespace((ContentType)type);
        }
        return this.discardLogicWhitespace;
    }

    public void setDiscardLogicWhitespace(Boolean discardLogicWhitespace) {
        this.discardLogicWhitespace = discardLogicWhitespace;
    }

    public Boolean getCombineAdjacentPlain() {
        return this.combineAdjacentPlain;
    }

    public void setCombineAdjacentPlain(Boolean combineAdjacentPlain) {
        this.combineAdjacentPlain = combineAdjacentPlain;
    }

    public String getExtendsClass() {
        return this.extendsClass;
    }

    public void setExtendsClass(String extendsClass) {
        this.extendsClass = extendsClass;
    }

    public String getExtendsModelClass() {
        return this.extendsModelClass;
    }

    public void setExtendsModelClass(String extendsModelClass) {
        this.extendsModelClass = extendsModelClass;
    }

    public String getTargetCharset() {
        return this.targetCharset;
    }

    public void setTargetCharset(String targetCharset) {
        Charset.forName(targetCharset);
        this.targetCharset = targetCharset;
    }

    public Boolean getOptimize() {
        return this.optimize;
    }

    public void setOptimize(Boolean optimize) {
        this.optimize = optimize;
    }

    public Boolean getMarkAsGenerated() {
        return this.markAsGenerated;
    }

    public void setMarkAsGenerated(Boolean markAsGenerated) {
        this.markAsGenerated = markAsGenerated;
    }

    public String[] getPostProcessing() {
        return this.postProcessing;
    }

    public void setPostProcessing(String[] postProcessing) {
        this.postProcessing = postProcessing;
    }

    public void set(String name, String value) throws TokenException {
        String optionName = name.trim();
        String optionValue = value.trim();
        switch (optionName) {
            case "discardLogicWhitespace": {
                this.setDiscardLogicWhitespace(this.parseBoolean(optionValue));
                break;
            }
            case "combineAdjacentPlain": {
                this.setCombineAdjacentPlain(this.parseBoolean(optionValue));
                break;
            }
            case "javaVersion": {
                this.setJavaVersion(optionValue);
                break;
            }
            case "extendsClass": {
                this.setExtendsClass(optionValue);
                break;
            }
            case "extendsModelClass": {
                this.setExtendsModelClass(optionValue);
                break;
            }
            case "targetCharset": {
                this.setTargetCharset(optionValue);
                break;
            }
            case "optimize": {
                this.setOptimize(this.parseBoolean(optionValue));
                break;
            }
            case "postProcessing": {
                this.setPostProcessing(this.parseStringArrayFromList(optionValue));
                break;
            }
            case "markAsGenerated": {
                this.setMarkAsGenerated(this.parseBoolean(optionValue));
                break;
            }
            default: {
                throw new TokenException("Invalid option (" + optionName + ") is not a property)");
            }
        }
    }

    public void write(Properties properties) {
        if (this.optimize != null) {
            properties.put("rocker.option.optimize", this.optimize.toString());
        }
        if (this.discardLogicWhitespace != null) {
            properties.put("rocker.option.discardLogicWhitespace", this.discardLogicWhitespace.toString());
        }
        if (this.combineAdjacentPlain != null) {
            properties.put("rocker.option.combineAdjacentPlain", this.combineAdjacentPlain.toString());
        }
        if (this.javaVersion != null) {
            properties.put("rocker.option.javaVersion", this.javaVersion.getLabel());
        }
        properties.put("rocker.option.extendsClass", this.extendsClass);
        properties.put("rocker.option.extendsModelClass", this.extendsModelClass);
        properties.put("rocker.option.targetCharset", this.targetCharset);
        if (this.postProcessing != null && this.postProcessing.length != 0) {
            properties.put("rocker.option.postProcessing", StringUtils.join((Object[])this.postProcessing, (String)","));
        }
        if (this.markAsGenerated != null) {
            properties.put("rocker.option.markAsGenerated", this.markAsGenerated.toString());
        }
    }

    public void parseOption(Option option) throws ParserException {
        String statement = option.getStatement();
        if (!statement.contains("=")) {
            throw TemplateParser.buildParserException(option.getSourceRef(), null, "Invalid option (missing = token; format name=value)");
        }
        String[] nameValuePair = statement.split("=");
        if (nameValuePair == null || nameValuePair.length != 2) {
            throw TemplateParser.buildParserException(option.getSourceRef(), null, "Invalid option (must have only a single = token)");
        }
        try {
            this.set(nameValuePair[0], nameValuePair[1]);
        }
        catch (TokenException e) {
            throw TemplateParser.buildParserException(option.getSourceRef(), null, e.getMessage(), e);
        }
    }

    private Boolean parseBoolean(String value) throws TokenException {
        if (value == null) {
            throw new TokenException("Boolean option cannot be null");
        }
        if (value.equalsIgnoreCase("true")) {
            return Boolean.TRUE;
        }
        if (value.equalsIgnoreCase("false")) {
            return Boolean.FALSE;
        }
        throw new TokenException("Unparseable boolean");
    }

    private String[] parseStringArrayFromList(String value) throws TokenException {
        if (value == null) {
            throw new TokenException("List of strings cannot be null");
        }
        StringTokenizer st = new StringTokenizer(value, ",");
        String[] tokens = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            tokens[i++] = st.nextToken().trim();
        }
        return tokens;
    }
}

