/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.jne.internal;

import java.util.Arrays;
import java.util.HashMap;

public class MacSwVers {
    private final String productName;
    private final String productVersion;
    private final String buildVersion;

    private MacSwVers(String productName, String productVersion, String buildVersion) {
        this.productName = productName;
        this.productVersion = productVersion;
        this.buildVersion = buildVersion;
    }

    public static MacSwVers parse(String content) {
        if (content == null || content.trim().isEmpty()) {
            throw new IllegalArgumentException("sw_vers output cannot be null or empty.");
        }
        HashMap values = new HashMap();
        Arrays.stream(content.split("\n")).map(String::trim).filter(line -> line.contains(":")).forEach(line -> {
            int colonIndex = line.indexOf(58);
            if (colonIndex == -1) {
                return;
            }
            String key = line.substring(0, colonIndex).trim();
            String value = line.substring(colonIndex + 1).trim();
            if (!key.isEmpty()) {
                values.put(key, value);
            }
        });
        return new MacSwVers((String)values.get("ProductName"), (String)values.get("ProductVersion"), (String)values.get("BuildVersion"));
    }

    public String getProductName() {
        return this.productName;
    }

    public String getProductVersion() {
        return this.productVersion;
    }

    public String getBuildVersion() {
        return this.buildVersion;
    }

    public String toString() {
        return "SwVer {productName='" + this.productName + '\'' + ", productVersion='" + this.productVersion + '\'' + ", buildVersion='" + this.buildVersion + '\'' + '}';
    }
}

