/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.jne;

import com.fizzed.jne.EnvScope;
import com.fizzed.jne.InstallEnvironment;
import com.fizzed.jne.JavaHome;
import com.fizzed.jne.JavaHomes;
import com.fizzed.jne.NativeTarget;
import com.fizzed.jne.PlatformInfo;
import com.fizzed.jne.UserEnvironment;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public class DetectMain {
    public static void main(String[] args) throws Exception {
        List<JavaHome> javaHomes = null;
        PlatformInfo basicPlatformInfo = null;
        PlatformInfo allPlatformInfo = null;
        NativeTarget nativeTarget = null;
        UserEnvironment logicalUserEnvironment = null;
        UserEnvironment effectiveUserEnvironment = null;
        InstallEnvironment systemInstallEnvironment = null;
        InstallEnvironment userInstallEnvironment = null;
        DetectMain.logInfo("###################################################################################################", new Object[0]);
        DetectMain.logInfo("Detecting Java Homes....", new Object[0]);
        try {
            javaHomes = JavaHomes.detect();
        }
        catch (Throwable t) {
            DetectMain.logError("Unable to detect java homes", t);
        }
        DetectMain.logInfo("###################################################################################################", new Object[0]);
        DetectMain.logInfo("###################################################################################################", new Object[0]);
        DetectMain.logInfo("Detecting Basic Platform Info....", new Object[0]);
        try {
            basicPlatformInfo = PlatformInfo.detectBasic();
        }
        catch (Throwable t) {
            DetectMain.logError("Unable to detect basic platform info", t);
        }
        DetectMain.logInfo("###################################################################################################", new Object[0]);
        DetectMain.logInfo("###################################################################################################", new Object[0]);
        DetectMain.logInfo("Detecting All Platform Info....", new Object[0]);
        try {
            allPlatformInfo = PlatformInfo.detect(PlatformInfo.Detect.ALL);
        }
        catch (Throwable t) {
            DetectMain.logError("Unable to detect all platform info", t);
        }
        DetectMain.logInfo("###################################################################################################", new Object[0]);
        DetectMain.logInfo("###################################################################################################", new Object[0]);
        DetectMain.logInfo("Detecting Native Target....", new Object[0]);
        try {
            nativeTarget = NativeTarget.detect();
        }
        catch (Throwable t) {
            DetectMain.logError("Unable to detect native target", t);
        }
        DetectMain.logInfo("###################################################################################################", new Object[0]);
        DetectMain.logInfo("###################################################################################################", new Object[0]);
        DetectMain.logInfo("Detecting Logical User Environment....", new Object[0]);
        try {
            logicalUserEnvironment = UserEnvironment.detectLogical();
        }
        catch (Throwable t) {
            DetectMain.logError("Unable to detect logical user environment", t);
        }
        DetectMain.logInfo("###################################################################################################", new Object[0]);
        DetectMain.logInfo("###################################################################################################", new Object[0]);
        DetectMain.logInfo("Detecting Effective User Environment....", new Object[0]);
        try {
            effectiveUserEnvironment = UserEnvironment.detectEffective();
        }
        catch (Throwable t) {
            DetectMain.logError("Unable to detect effective user environment", t);
        }
        DetectMain.logInfo("###################################################################################################", new Object[0]);
        DetectMain.logInfo("###################################################################################################", new Object[0]);
        DetectMain.logInfo("Detecting System Install Environment....", new Object[0]);
        try {
            systemInstallEnvironment = InstallEnvironment.detect("JNE Demo", "jne-demo", EnvScope.SYSTEM);
        }
        catch (Throwable t) {
            DetectMain.logError("Unable to detect system install environment", t);
        }
        DetectMain.logInfo("###################################################################################################", new Object[0]);
        DetectMain.logInfo("###################################################################################################", new Object[0]);
        DetectMain.logInfo("Detecting User Install Environment....", new Object[0]);
        try {
            userInstallEnvironment = InstallEnvironment.detect("JNE Demo", "jne-demo", EnvScope.USER);
        }
        catch (Throwable t) {
            DetectMain.logError("Unable to detect user install environment", t);
        }
        DetectMain.logInfo("###################################################################################################", new Object[0]);
        DetectMain.logDetection("Java Homes", javaHomes, v -> {
            for (JavaHome javaHome : v) {
                DetectMain.logInfo("JavaHome: {}", javaHome.getDirectory());
                DetectMain.logInfo("  javaExe: {}", javaHome.getJavaExe());
                DetectMain.logInfo("  javacExe: {}", javaHome.getJavacExe());
                DetectMain.logInfo("  nativeImageExe: {}", javaHome.getNativeImageExe());
                DetectMain.logInfo("  imageType: {}", new Object[]{javaHome.getImageType()});
                DetectMain.logInfo("  version: {}", javaHome.getVersion());
                DetectMain.logInfo("  os: {}", new Object[]{javaHome.getOperatingSystem()});
                DetectMain.logInfo("  arch: {}", new Object[]{javaHome.getHardwareArchitecture()});
                DetectMain.logInfo("  distro: {}", new Object[]{javaHome.getDistribution()});
                DetectMain.logInfo("  vendor: {}", javaHome.getVendor());
            }
        });
        DetectMain.logDetection("Basic Platform Info", basicPlatformInfo, v -> {
            DetectMain.logInfo("operatingSystem: {}", new Object[]{v.getOperatingSystem()});
            DetectMain.logInfo("hardwareArchitecture: {}", new Object[]{v.getHardwareArchitecture()});
            DetectMain.logInfo("libC: {}", new Object[]{v.getLibC()});
        });
        DetectMain.logDetection("All Platform Info", allPlatformInfo, v -> {
            DetectMain.logInfo("operatingSystem: {}", new Object[]{v.getOperatingSystem()});
            DetectMain.logInfo("hardwareArchitecture: {}", new Object[]{v.getHardwareArchitecture()});
            DetectMain.logInfo("name: {}", v.getName());
            DetectMain.logInfo("displayName: {}", v.getDisplayName());
            DetectMain.logInfo("version: {}", v.getVersion());
            DetectMain.logInfo("kernelVersion: {}", v.getKernelVersion());
            DetectMain.logInfo("uname: {}", v.getUname());
            DetectMain.logInfo("libC: {}", new Object[]{v.getLibC()});
            DetectMain.logInfo("libCVersion: {}", v.getLibCVersion());
        });
        DetectMain.logDetection("Native Target", nativeTarget, v -> {
            DetectMain.logInfo("operatingSystem: {}", new Object[]{v.getOperatingSystem()});
            DetectMain.logInfo("hardwareArchitecture: {}", new Object[]{v.getHardwareArchitecture()});
            DetectMain.logInfo("abi: {}", new Object[]{v.getAbi()});
            DetectMain.logInfo("executableFileExt: {}", v.getExecutableFileExtension());
            DetectMain.logInfo("executableFile (example): {}", v.resolveExecutableFileName("example"));
            DetectMain.logInfo("libraryFileExt: {}", v.getLibraryFileExtension());
            DetectMain.logInfo("libraryFile (example): {}", v.resolveLibraryFileName("example"));
            DetectMain.logInfo("resourcePathsForLibrary (example): {}", v.resolveResourcePaths("/jne", v.resolveLibraryFileName("example")));
            DetectMain.logInfo("jneTarget: {}", v.toJneTarget());
            DetectMain.logInfo("rustTarget: {}", v.toRustTarget());
            DetectMain.logInfo("autoConfTarget: {}", v.toAutoConfTarget());
        });
        DetectMain.logDetection("Logical User Environment", logicalUserEnvironment, v -> DetectMain.logUserEnvironment(v));
        DetectMain.logDetection("Effective User Environment", effectiveUserEnvironment, v -> DetectMain.logUserEnvironment(v));
        DetectMain.logDetection("System Install Environment", systemInstallEnvironment, v -> DetectMain.logInstallEnvironment(v));
        DetectMain.logDetection("User Install Environment", userInstallEnvironment, v -> DetectMain.logInstallEnvironment(v));
    }

    public static void logInfo(String format, Object ... args) {
        String f = format.replace("{}", "%s");
        String msg = String.format(f, args);
        System.out.println("[INFO] " + msg);
    }

    public static void logError(String format, Object ... args) {
        String f = format.replace("{}", "%s");
        String msg = String.format(f, args);
        System.out.println("[ERR ] " + msg);
    }

    public static <T> void logDetection(String title, T detection, Consumer<T> consumer) {
        Objects.requireNonNull(title);
        DetectMain.logInfo("###################################################################################################", new Object[0]);
        DetectMain.logInfo("{} Detected:", title);
        DetectMain.logInfo("", new Object[0]);
        if (detection != null) {
            try {
                consumer.accept(detection);
            }
            catch (Throwable t) {
                DetectMain.logError("Unable to cleanly log detection: {}", t.getMessage(), t);
            }
        } else {
            DetectMain.logError("Unable to detect {}!", title.toLowerCase());
        }
        DetectMain.logInfo("", new Object[0]);
        DetectMain.logInfo("###################################################################################################", new Object[0]);
    }

    public static void logUserEnvironment(UserEnvironment userEnvironment) {
        DetectMain.logInfo("user: {}", userEnvironment.getUser());
        DetectMain.logInfo("elevated: {}", userEnvironment.isElevated());
        DetectMain.logInfo("displayName: {}", userEnvironment.getDisplayName());
        DetectMain.logInfo("userId: {}", userEnvironment.getUserId());
        DetectMain.logInfo("groupId: {}", userEnvironment.getGroupId());
        DetectMain.logInfo("homeDir: {}", userEnvironment.getHomeDir());
        DetectMain.logInfo("shell: {}", userEnvironment.getShell());
        DetectMain.logInfo("shellType: {}", new Object[]{userEnvironment.getShellType()});
    }

    public static void logInstallEnvironment(InstallEnvironment installEnvironment) {
        DetectMain.logInfo("scope: {}", new Object[]{installEnvironment.getScope()});
        DetectMain.logInfo("unitName: {}", installEnvironment.getUnitName());
        DetectMain.logInfo("applicationName: {}", installEnvironment.getApplicationName());
        DetectMain.logInfo("", new Object[0]);
        DetectMain.logInfo("applicationRootDir: {}", installEnvironment.getApplicationRootDir());
        DetectMain.logInfo("systemRootDir: {}", installEnvironment.getSystemRootDir());
        DetectMain.logInfo("optRootDir: {}", installEnvironment.getOptRootDir());
        DetectMain.logInfo("localRootDir: {}", installEnvironment.getLocalRootDir());
        DetectMain.logInfo("", new Object[0]);
        DetectMain.logInfo("systemBinDir: {}", installEnvironment.getSystemBinDir());
        DetectMain.logInfo("systemShareDir: {}", installEnvironment.getSystemShareDir());
        DetectMain.logInfo("", new Object[0]);
        DetectMain.logInfo("applicationDir: {}", installEnvironment.getApplicationDir());
        DetectMain.logInfo("optApplicationDir: {}", installEnvironment.getOptApplicationDir());
        DetectMain.logInfo("localApplicationDir: {}", installEnvironment.getLocalApplicationDir());
        DetectMain.logInfo("localBinDir: {}", installEnvironment.getLocalBinDir());
        DetectMain.logInfo("localShareDir: {}", installEnvironment.getLocalShareDir());
    }
}

