/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.jne.internal;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcPasswd {
    private static final Logger log = LoggerFactory.getLogger(EtcPasswd.class);
    private final List<Entry> entries;

    public EtcPasswd(List<Entry> entries) {
        this.entries = entries;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public Entry findEntryByUserName(String userName) {
        if (userName == null) {
            return null;
        }
        for (Entry entry : this.entries) {
            if (!Objects.equals(entry.getUsername(), userName)) continue;
            return entry;
        }
        return null;
    }

    public Entry findEntryByUserId(Integer userId) {
        if (userId == null) {
            return null;
        }
        for (Entry entry : this.entries) {
            if (!Objects.equals(entry.getUserId(), userId)) continue;
            return entry;
        }
        return null;
    }

    public static EtcPasswd detect() {
        Path etcPasswdFile = Paths.get("/etc/passwd", new String[0]);
        if (Files.exists(etcPasswdFile, new LinkOption[0])) {
            try {
                return EtcPasswd.parse(etcPasswdFile);
            }
            catch (IOException e) {
                log.debug("Unable to parse etc passwd file: {}", (Object)e.getMessage());
            }
        }
        return null;
    }

    public static EtcPasswd parse(Path file) throws IOException {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        try (Stream<String> lines = Files.lines(file);){
            Iterator it = lines.iterator();
            while (it.hasNext()) {
                String line = (String)it.next();
                String[] parts = line.split(":");
                if (parts.length != 7) continue;
                Entry entry = new Entry();
                entry.setUsername(parts[0]);
                entry.setUserId(Integer.valueOf(parts[2]));
                entry.setGroupId(Integer.valueOf(parts[3]));
                entry.setName(parts[4]);
                entry.setHome(parts[5]);
                entry.setShell(parts[6]);
                entries.add(entry);
            }
        }
        return new EtcPasswd(entries);
    }

    public static class Entry {
        private String username;
        private Integer userId;
        private Integer groupId;
        private String name;
        private String home;
        private String shell;

        public String getUsername() {
            return this.username;
        }

        public Entry setUsername(String username) {
            this.username = username;
            return this;
        }

        public Integer getUserId() {
            return this.userId;
        }

        public Entry setUserId(Integer userId) {
            this.userId = userId;
            return this;
        }

        public Integer getGroupId() {
            return this.groupId;
        }

        public Entry setGroupId(Integer groupId) {
            this.groupId = groupId;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Entry setName(String name) {
            this.name = name;
            return this;
        }

        public String getHome() {
            return this.home;
        }

        public Entry setHome(String home) {
            this.home = home;
            return this;
        }

        public String getShell() {
            return this.shell;
        }

        public Entry setShell(String shell) {
            this.shell = shell;
            return this;
        }
    }
}

