/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.jne.internal;

import com.fizzed.jne.internal.Utils;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsRegistry {
    private static final Logger log = LoggerFactory.getLogger(WindowsRegistry.class);

    public static Map<String, String> queryUserEnvironmentVariables() throws IOException, InterruptedException {
        String output = Utils.execAndGetOutput(Arrays.asList("reg.exe", "query", "HKEY_CURRENT_USER\\Environment"));
        return WindowsRegistry.parseEnvironmentVariableRegQueryOutput(output);
    }

    public static Map<String, String> querySystemEnvironmentVariables() throws IOException, InterruptedException {
        String output = Utils.execAndGetOutput(Arrays.asList("reg.exe", "query", "HKLM\\SYSTEM\\CurrentControlSet\\Control\\Session Manager\\Environment"));
        return WindowsRegistry.parseEnvironmentVariableRegQueryOutput(output);
    }

    public static Map<String, String> parseEnvironmentVariableRegQueryOutput(String output) throws IOException {
        TreeMap<String, String> env = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        int pos = 0;
        int nextNewlinePos = output.indexOf(10, pos);
        while (nextNewlinePos > 0) {
            String line = output.substring(pos, nextNewlinePos);
            if (!((line = line.trim()).isEmpty() || line.startsWith("HKEY_CURRENT_USER\\") || line.startsWith("HKEY_LOCAL_MACHINE\\"))) {
                if (line.contains("REG_")) {
                    String[] parts = line.split("\\s+(REG_\\w+)\\s+");
                    if (parts.length == 2) {
                        env.put(parts[0], parts[1]);
                    } else {
                        log.warn("Unable to parse reg query output line: {}", (Object)line);
                    }
                } else {
                    log.warn("Unexpected windows req query line: {}", (Object)line);
                }
            }
            pos = nextNewlinePos + 1;
            nextNewlinePos = output.indexOf(10, pos);
        }
        return env;
    }
}

