/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.jne;

import com.fizzed.jne.ABI;
import com.fizzed.jne.HardwareArchitecture;
import com.fizzed.jne.OperatingSystem;
import java.io.File;

public class Options {
    public static final Options DEFAULT = new Options();
    public static final String SYSPROP_DEBUG = "jne.debug";
    public static final String SYSPROP_RESOURCE_PREFIX = "jne.resource.prefix";
    public static final String SYSPROP_EXTRACT_DIR = "jne.extract.dir";
    public static final String SYSPROP_CLEANUP_EXTRACTED = "jne.cleanup.extracted";
    public static final String SYSPROP_X32_EXE_FALLBACK = "jne.x32.exe.fallback";
    private HardwareArchitecture hardwareArchitecture = null;
    private OperatingSystem operatingSystem = null;
    private ABI abi = null;
    private String resourcePrefix = System.getProperty("jne.resource.prefix", "/jne");
    private File extractDir = Options.getSystemPropertyAsFile("jne.extract.dir", null);
    private boolean x32ExecutableFallback = Options.getSystemPropertyAsBoolean("jne.x32.exe.fallback", false);
    private boolean cleanupExtracted = Options.getSystemPropertyAsBoolean("jne.cleanup.extracted", true);

    public HardwareArchitecture getHardwareArchitecture() {
        return this.hardwareArchitecture;
    }

    public Options setHardwareArchitecture(HardwareArchitecture hardwareArchitecture) {
        this.hardwareArchitecture = hardwareArchitecture;
        return this;
    }

    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    public Options setOperatingSystem(OperatingSystem operatingSystem) {
        this.operatingSystem = operatingSystem;
        return this;
    }

    public ABI getAbi() {
        return this.abi;
    }

    public Options setAbi(ABI abi) {
        this.abi = abi;
        return this;
    }

    public String getResourcePrefix() {
        return this.resourcePrefix;
    }

    public Options setResourcePrefix(String resourcePrefix) {
        this.resourcePrefix = resourcePrefix;
        return this;
    }

    public File getExtractDir() {
        return this.extractDir;
    }

    public Options setExtractDir(File extractDir) {
        this.extractDir = extractDir;
        return this;
    }

    public boolean isX32ExecutableFallback() {
        return this.x32ExecutableFallback;
    }

    public Options setX32ExecutableFallback(boolean x32ExecutableFallback) {
        this.x32ExecutableFallback = x32ExecutableFallback;
        return this;
    }

    public boolean isCleanupExtracted() {
        return this.cleanupExtracted;
    }

    public Options setCleanupExtracted(boolean cleanupExtracted) {
        this.cleanupExtracted = cleanupExtracted;
        return this;
    }

    private static File getSystemPropertyAsFile(String key, File defaultValue) {
        String v = System.getProperty(key);
        if (v != null && !v.equals("")) {
            return new File(v);
        }
        return defaultValue;
    }

    private static boolean getSystemPropertyAsBoolean(String key, boolean defaultValue) {
        String v = System.getProperty(key);
        if (v != null) {
            if (v.equalsIgnoreCase("true") || v.equalsIgnoreCase("1")) {
                return true;
            }
            if (v.equalsIgnoreCase("false") || v.equalsIgnoreCase("0")) {
                return false;
            }
            throw new IllegalArgumentException("Invalid boolean value for system property [" + key + "]");
        }
        return defaultValue;
    }
}

