/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.jne.internal;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.TreeMap;
import java.util.stream.Stream;

public class OsReleaseFile {
    private final Map<String, String> values;

    public OsReleaseFile(Map<String, String> values) {
        this.values = values;
    }

    public String get(String key) {
        return this.values.get(key);
    }

    public String getName() {
        return this.get("NAME");
    }

    public String getVersion() {
        return this.get("VERSION");
    }

    public String getId() {
        return this.get("ID");
    }

    public String getIdLike() {
        return this.get("ID_LIKE");
    }

    public String getPrettyName() {
        return this.get("PRETTY_NAME");
    }

    public String getVersionId() {
        return this.get("VERSION_ID");
    }

    public static OsReleaseFile parse(Path path) throws IOException {
        try (Stream<String> stream = Files.lines(path);){
            Map<String, String> properties = OsReleaseFile.parseLines(stream);
            OsReleaseFile osReleaseFile = new OsReleaseFile(properties);
            return osReleaseFile;
        }
    }

    public static OsReleaseFile parse(String content) {
        Stream<String> stream = Stream.of(content.split("\\r?\\n"));
        Map<String, String> properties = OsReleaseFile.parseLines(stream);
        return new OsReleaseFile(properties);
    }

    private static Map<String, String> parseLines(Stream<String> stream) {
        TreeMap<String, String> values = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        stream.filter(line -> line != null && !line.trim().isEmpty() && !line.trim().startsWith("#")).map(line -> line.split("=", 2)).filter(parts -> ((String[])parts).length == 2).forEach(parts -> {
            String key = parts[0].trim();
            String value = OsReleaseFile.unquote(parts[1].trim());
            values.put(key, value);
        });
        return values;
    }

    private static String unquote(String value) {
        if (value == null) {
            return null;
        }
        String trimmed = value.trim();
        if (trimmed.startsWith("\"") && trimmed.endsWith("\"") && trimmed.length() > 1) {
            return trimmed.substring(1, trimmed.length() - 1);
        }
        return trimmed;
    }
}

