/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.jne.internal;

import com.fizzed.jne.LibC;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LibCs {
    static final Pattern GLIBC_VERSION_PATTERN = Pattern.compile("(\\d+\\.\\d+)");
    static final Pattern MUSL_VERSION_PATTERN = Pattern.compile("(\\d+\\.\\d+\\.\\d+)");

    public static PathResult parsePath(String content) {
        String[] lines;
        if (content == null || content.isEmpty()) {
            return null;
        }
        for (String line : lines = content.split("\n")) {
            String pathPart;
            String[] pathTokens;
            String[] nameAndPath;
            if (!(line = line.trim()).contains("=>") || (nameAndPath = line.split("=>")).length < 1) continue;
            String libName = nameAndPath[0].toLowerCase().trim();
            LibC libC = null;
            if (libName.contains("libc") && line.contains("musl")) {
                libC = LibC.MUSL;
            } else if (libName.startsWith("libuclibc.so")) {
                libC = LibC.UCLIBC;
            } else if (libName.startsWith("libc.so")) {
                libC = LibC.GLIBC;
            }
            if (libC == null || nameAndPath.length < 2 || (pathTokens = (pathPart = nameAndPath[1].trim()).split("\\s+")).length <= 0) continue;
            return new PathResult(libC, pathTokens[0]);
        }
        return null;
    }

    public static String parseVersion(String content) {
        Matcher matcher;
        if (content == null || content.isEmpty()) {
            return null;
        }
        if (content.contains("GNU C")) {
            Matcher matcher2 = GLIBC_VERSION_PATTERN.matcher(content);
            if (matcher2.find()) {
                return matcher2.group(1);
            }
        } else if (content.contains("musl libc") && (matcher = MUSL_VERSION_PATTERN.matcher(content)).find()) {
            return matcher.group(1);
        }
        return null;
    }

    public static class PathResult {
        private final LibC libC;
        private final String path;

        public PathResult(LibC libC, String path) {
            this.libC = libC;
            this.path = path;
        }

        public LibC getLibC() {
            return this.libC;
        }

        public String getPath() {
            return this.path;
        }
    }
}

