/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.jne;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;

public class SemanticVersion
implements Comparable<SemanticVersion> {
    private final int major;
    private final int minor;
    private final int patch;
    private final int revision;
    private final String flavor;
    private final String buildMetadata;
    private final String source;

    private SemanticVersion(int major, int minor, int patch, int revision, String flavor, String buildMetadata, String source) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.revision = revision;
        this.flavor = flavor == null || flavor.isEmpty() ? null : flavor;
        this.buildMetadata = buildMetadata == null || buildMetadata.isEmpty() ? null : buildMetadata;
        this.source = source;
    }

    private static int parseInt(String s) {
        if (s == null) {
            return 0;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    private static boolean isNumeric(String s) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        for (char c : s.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static SemanticVersion parse(String versionString) {
        if (versionString == null || versionString.trim().isEmpty()) {
            throw new IllegalArgumentException("Version string cannot be null or empty.");
        }
        String originalSource = versionString.trim();
        String buildMetadata = null;
        String mainPart = originalSource;
        int plusIndex = mainPart.indexOf(43);
        if (plusIndex != -1) {
            buildMetadata = mainPart.substring(plusIndex + 1);
            mainPart = mainPart.substring(0, plusIndex);
        }
        String[] components = mainPart.split("[.\\-_]");
        ArrayList<Integer> numParts = new ArrayList<Integer>();
        ArrayList<String> flavorParts = new ArrayList<String>();
        for (String component : components) {
            if (component.isEmpty()) continue;
            if (flavorParts.isEmpty() && SemanticVersion.isNumeric(component) && numParts.size() < 4) {
                numParts.add(SemanticVersion.parseInt(component));
                continue;
            }
            flavorParts.add(component);
        }
        if (numParts.isEmpty()) {
            throw new IllegalArgumentException("Invalid version string [" + originalSource + "]");
        }
        int major = numParts.size() > 0 ? (Integer)numParts.get(0) : 0;
        int minor = numParts.size() > 1 ? (Integer)numParts.get(1) : 0;
        int patch = numParts.size() > 2 ? (Integer)numParts.get(2) : 0;
        int revision = numParts.size() > 3 ? (Integer)numParts.get(3) : 0;
        String flavor = flavorParts.isEmpty() ? null : String.join((CharSequence)"-", flavorParts);
        return new SemanticVersion(major, minor, patch, revision, flavor, buildMetadata, originalSource);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public int getRevision() {
        return this.revision;
    }

    public String getFlavor() {
        return this.flavor;
    }

    public String getBuildMetadata() {
        return this.buildMetadata;
    }

    public String getSource() {
        return this.source;
    }

    @Override
    public int compareTo(SemanticVersion that) {
        if (that == null) {
            return 1;
        }
        if (this.major != that.major) {
            return Integer.compare(this.major, that.major);
        }
        if (this.minor != that.minor) {
            return Integer.compare(this.minor, that.minor);
        }
        if (this.patch != that.patch) {
            return Integer.compare(this.patch, that.patch);
        }
        if (this.revision != that.revision) {
            return Integer.compare(this.revision, that.revision);
        }
        if (this.flavor == null && that.flavor != null) {
            return 1;
        }
        if (this.flavor != null && that.flavor == null) {
            return -1;
        }
        if (this.flavor == null && that.flavor == null) {
            return 0;
        }
        return this.flavor.compareTo(that.flavor);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SemanticVersion that = (SemanticVersion)o;
        return this.major == that.major && this.minor == that.minor && this.patch == that.patch && this.revision == that.revision;
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.patch, this.revision);
    }

    public String toString() {
        if (this.revision > 0) {
            return String.format("%d.%d.%d.%d", this.major, this.minor, this.patch, this.revision);
        }
        if (this.patch > 0) {
            return String.format("%d.%d.%d", this.major, this.minor, this.patch);
        }
        if (this.minor > 0) {
            return String.format("%d.%d", this.major, this.minor);
        }
        if (this.major > 0) {
            return String.format("%d", this.major);
        }
        return this.source;
    }

    public String dumpAll() {
        return "SemanticVersion {major=" + this.major + ", minor=" + this.minor + ", patch=" + this.patch + ", revision=" + this.revision + ", flavor='" + (this.flavor != null ? this.flavor : "") + '\'' + ", buildMetadata='" + (this.buildMetadata != null ? this.buildMetadata : "") + '\'' + ", original='" + this.source + '\'' + '}';
    }

    public static void main(String[] args) {
        ArrayList<String> releaseStrings = new ArrayList<String>();
        releaseStrings.add("5.15.0-88-generic");
        releaseStrings.add("23.1.0");
        releaseStrings.add("13.2-RELEASE");
        releaseStrings.add("7.4");
        releaseStrings.add("9.2_STABLE");
        releaseStrings.add("6.2.1-RELEASE");
        releaseStrings.add("5.11");
        releaseStrings.add("4.19.113-gbe0c0b1122a2");
        releaseStrings.add("5.15.61-0-lts");
        releaseStrings.add("13.2-BETA");
        releaseStrings.add("13.2");
        releaseStrings.add("1.8.0_311");
        releaseStrings.add("11.0.1");
        releaseStrings.add("17.0.5+8-LTS-191");
        releaseStrings.add("21.0.1+12-LTS");
        releaseStrings.add("23-ea+20");
        ArrayList<SemanticVersion> versions = new ArrayList<SemanticVersion>();
        System.out.println("--- Parsing... ---");
        for (String s : releaseStrings) {
            SemanticVersion v = SemanticVersion.parse(s);
            versions.add(v);
            System.out.println("Parsed: " + v);
        }
        System.out.println("\n--- Sorting... ---");
        Collections.sort(versions);
        System.out.println("\n--- Sorted Results (Original Strings) ---");
        for (SemanticVersion v : versions) {
            System.out.println(v.getSource());
        }
    }
}

