/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.jne;

import com.fizzed.jne.ABI;
import com.fizzed.jne.HardwareArchitecture;
import com.fizzed.jne.LibC;
import com.fizzed.jne.MemoizedInitializer;
import com.fizzed.jne.NativeTarget;
import com.fizzed.jne.OperatingSystem;
import com.fizzed.jne.SemanticVersion;
import com.fizzed.jne.internal.LibCResult;
import com.fizzed.jne.internal.LibCs;
import com.fizzed.jne.internal.MacReleases;
import com.fizzed.jne.internal.MacSwVers;
import com.fizzed.jne.internal.OsReleaseFile;
import com.fizzed.jne.internal.SystemExecutor;
import com.fizzed.jne.internal.Uname;
import com.fizzed.jne.internal.WindowsRegistry;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlatformInfo {
    private static final Logger log = LoggerFactory.getLogger(PlatformInfo.class);
    private final OperatingSystem operatingSystem;
    private final HardwareArchitecture hardwareArchitecture;
    private final String name;
    private final String displayName;
    private final SemanticVersion version;
    private final SemanticVersion kernelVersion;
    private final String uname;
    private final LibC libC;
    private final SemanticVersion libCVersion;
    private static final MemoizedInitializer<OperatingSystem> operatingSystemRef = new MemoizedInitializer();
    private static final MemoizedInitializer<HardwareArchitecture> hardwareArchitectureRef = new MemoizedInitializer();
    private static final ConcurrentHashMap<OperatingSystem, ABI> abiRefs = new ConcurrentHashMap();
    private static final MemoizedInitializer<LibC> linuxLibCRef = new MemoizedInitializer();
    private static final MemoizedInitializer<LinuxDetectedFilesResult> libFilesResultRef = new MemoizedInitializer();
    private static final MemoizedInitializer<LinuxDetectedFilesResult> mappedFilesResultRef = new MemoizedInitializer();

    private PlatformInfo(OperatingSystem operatingSystem, HardwareArchitecture hardwareArchitecture, String name, String displayName, SemanticVersion version, SemanticVersion kernelVersion, String uname, LibC libC, SemanticVersion libCVersion) {
        this.operatingSystem = operatingSystem;
        this.hardwareArchitecture = hardwareArchitecture;
        this.name = name;
        this.displayName = displayName;
        this.version = version;
        this.kernelVersion = kernelVersion;
        this.uname = uname;
        this.libC = libC;
        this.libCVersion = libCVersion;
    }

    public OperatingSystem getOperatingSystem() {
        return this.operatingSystem;
    }

    public HardwareArchitecture getHardwareArchitecture() {
        return this.hardwareArchitecture;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public SemanticVersion getVersion() {
        return this.version;
    }

    public SemanticVersion getKernelVersion() {
        return this.kernelVersion;
    }

    public String getUname() {
        return this.uname;
    }

    public LibC getLibC() {
        return this.libC;
    }

    public SemanticVersion getLibCVersion() {
        return this.libCVersion;
    }

    public static PlatformInfo detect(Detect ... detects) {
        return PlatformInfo.detect(SystemExecutor.LOCAL, detects);
    }

    public static PlatformInfo detect(SystemExecutor systemExecutor, Detect ... detects) {
        LibCResult libcResult;
        NativeTarget nativeTarget;
        long startTime = System.currentTimeMillis();
        EnumSet<Detect> detectSet = EnumSet.copyOf(Arrays.asList(detects));
        OperatingSystem operatingSystem = null;
        HardwareArchitecture hardwareArchitecture = null;
        String name = null;
        String displayName = null;
        SemanticVersion version = null;
        SemanticVersion kernelVersion = null;
        Uname uname = null;
        LibC libC = null;
        SemanticVersion libCVersion = null;
        try {
            log.debug("Trying 'uname -a' to detect system platform...");
            String unameOutput = systemExecutor.execProcess(Arrays.asList(0), "uname", "-a");
            try {
                uname = Uname.parse(unameOutput);
            }
            catch (Exception ex) {
                log.warn("Unable to parse 'uname -a' output: {}", (Object)ex.getMessage());
                uname = null;
            }
        }
        catch (Exception e) {
            log.debug("Unable to execute 'uname -a' to detect system platform: {}", (Object)e.getMessage());
            uname = null;
        }
        if (uname == null || uname.getSource().toLowerCase().contains("cygwin") || uname.getSource().toLowerCase().contains("msys")) {
            try {
                log.debug("Trying windows registry to detect system platform...");
                WindowsRegistry windowsRegistryCurrentVersion = WindowsRegistry.queryCurrentVersion(systemExecutor);
                WindowsRegistry windowsRegistrySystemEnvironment = WindowsRegistry.querySystemEnvironmentVariables(systemExecutor);
                WindowsRegistry windowsRegistryComputerName = WindowsRegistry.queryComputerName(systemExecutor);
                int majorVersion = Optional.ofNullable(windowsRegistryCurrentVersion.get("CurrentMajorVersionNumber")).map(Integer::parseInt).orElse(-1);
                int minorVersion = Optional.ofNullable(windowsRegistryCurrentVersion.get("CurrentMinorVersionNumber")).map(Integer::parseInt).orElse(-1);
                int buildVersion = Optional.ofNullable(windowsRegistryCurrentVersion.get("CurrentBuildNumber")).map(Integer::parseInt).orElse(-1);
                String currentVersion = windowsRegistryCurrentVersion.get("CurrentVersion");
                String productName = windowsRegistryCurrentVersion.get("ProductName");
                String displayVersion = windowsRegistryCurrentVersion.get("DisplayVersion");
                String computerName = windowsRegistryComputerName.get("ComputerName");
                String processorArchitecture = windowsRegistrySystemEnvironment.get("PROCESSOR_ARCHITECTURE");
                if (buildVersion >= 22000) {
                    productName = productName.replace(" 10 ", " 11 ");
                }
                if (displayVersion != null) {
                    productName = productName + " (" + displayVersion + ")";
                }
                String kernelVersionString = majorVersion > 0 ? majorVersion + "." + minorVersion + "." + buildVersion : currentVersion + "." + buildVersion;
                String osVersionString = buildVersion >= 22000 && majorVersion == 10 ? "11." + minorVersion + "." + buildVersion : (majorVersion > 0 ? majorVersion + "." + minorVersion + "." + buildVersion : (majorVersion < 0 ? ("6.3".equals(currentVersion) ? "8.1." + buildVersion : ("6.2".equals(currentVersion) ? "8.0." + buildVersion : "7.0." + buildVersion)) : currentVersion));
                String unameString = "Windows " + computerName + " " + osVersionString + " " + productName + " " + processorArchitecture;
                log.debug("Generated windows os version={}, uname-{}", (Object)osVersionString, (Object)unameString);
                uname = Uname.parse(unameString);
                kernelVersion = SemanticVersion.parse(kernelVersionString);
                name = "Windows";
                displayName = productName;
            }
            catch (Exception e) {
                log.debug("Unable to query windows registry to detect system platform: {}", (Object)e.getMessage());
            }
        }
        if (uname != null) {
            try {
                String sourceWithoutHost;
                log.debug("Detecting os & arch from 'uname -a' output...");
                NativeTarget nativeTarget2 = NativeTarget.detectFromText(uname.getSysname() + " " + uname.getOperatingSystem() + " " + uname.getMachine() + " " + uname.getHardwarePlatform());
                operatingSystem = nativeTarget2.getOperatingSystem();
                hardwareArchitecture = nativeTarget2.getHardwareArchitecture();
                if (operatingSystem == null) {
                    sourceWithoutHost = uname.getSource().replace(uname.getNodename(), "host");
                    nativeTarget2 = NativeTarget.detectFromText(sourceWithoutHost);
                    operatingSystem = nativeTarget2.getOperatingSystem();
                }
                if (hardwareArchitecture == null) {
                    sourceWithoutHost = uname.getSource().replace(uname.getNodename(), "host");
                    nativeTarget2 = NativeTarget.detectFromText(sourceWithoutHost);
                    hardwareArchitecture = nativeTarget2.getHardwareArchitecture();
                }
                try {
                    version = SemanticVersion.parse(uname.getVersion());
                }
                catch (Exception ex) {
                    log.warn("Unable to parse 'uname -a' VERSION: {}", (Object)ex.getMessage());
                }
                if (name == null) {
                    name = uname.getSysname();
                }
                if (version != null && displayName == null) {
                    displayName = name + " " + version;
                }
            }
            catch (Exception e) {
                log.warn("Unable to detect operating system from 'uname -a' output: {}", (Object)e.getMessage());
            }
        }
        if (operatingSystem == OperatingSystem.LINUX || operatingSystem == OperatingSystem.MACOS) {
            kernelVersion = version;
            version = null;
        }
        OsReleaseFile osReleaseFile = null;
        if (operatingSystem == OperatingSystem.LINUX || operatingSystem == OperatingSystem.FREEBSD) {
            log.debug("Trying /etc/os-release to detect platform info...");
            try {
                String osReleaseFileOutput = systemExecutor.catFile("/etc/os-release");
                osReleaseFile = OsReleaseFile.parse(osReleaseFileOutput);
                name = osReleaseFile.getName();
                displayName = osReleaseFile.getVersion() != null ? name + " " + osReleaseFile.getVersion() : (osReleaseFile.getPrettyName() != null ? osReleaseFile.getPrettyName() : (osReleaseFile.getVersionId() != null ? name + " " + osReleaseFile.getVersionId() : name));
                try {
                    version = SemanticVersion.parse(osReleaseFile.getVersionId());
                }
                catch (Exception ex) {
                    log.warn("Unable to parse /etc/os-release VERSION_ID: {}", (Object)ex.getMessage());
                }
            }
            catch (Exception e) {
                log.debug("Unable to read /etc/os-release file: {}", (Object)e.getMessage());
            }
        }
        if (operatingSystem == OperatingSystem.NETBSD || operatingSystem == OperatingSystem.FREEBSD || operatingSystem == OperatingSystem.OPENBSD) {
            try {
                String sysctlMachineArchInfo = systemExecutor.execProcess("/sbin/sysctl", "-n", "hw.machine_arch");
                nativeTarget = NativeTarget.detectFromText(sysctlMachineArchInfo);
                if (nativeTarget.getHardwareArchitecture() != null) {
                    hardwareArchitecture = nativeTarget.getHardwareArchitecture();
                }
            }
            catch (Exception e) {
                log.warn("Unable to detect more accurate hardware architecture from 'sysctl -n hw.machine_arch' output: {}", (Object)e.getMessage());
            }
        }
        if (operatingSystem == OperatingSystem.SOLARIS) {
            try {
                String isaInfo = systemExecutor.execProcess("isainfo", "-k");
                nativeTarget = NativeTarget.detectFromText(isaInfo);
                if (nativeTarget.getHardwareArchitecture() != null) {
                    hardwareArchitecture = nativeTarget.getHardwareArchitecture();
                }
            }
            catch (Exception e) {
                log.warn("Unable to detect more accurate hardware architecture from 'isainfo -k' output: {}", (Object)e.getMessage());
            }
            log.debug("Trying /etc/release to detect platform info...");
            try {
                String maybeDisplayName;
                String[] releaseFileOutputLines;
                String releaseFileOutput = systemExecutor.catFile("/etc/release");
                if (releaseFileOutput != null && releaseFileOutput.contains("\n") && (releaseFileOutputLines = releaseFileOutput.split("\n")).length > 1 && (maybeDisplayName = releaseFileOutputLines[0].trim()).matches(".*\\d+.*")) {
                    displayName = maybeDisplayName;
                }
            }
            catch (Exception e) {
                log.debug("Unable to read /etc/release file: {}", (Object)e.getMessage());
            }
        }
        if (operatingSystem == OperatingSystem.MACOS) {
            log.debug("Trying macos 'sw_vers' to detect platform info...");
            MacSwVers swVers = null;
            try {
                String swVersOutput = systemExecutor.execProcess("sw_vers");
                swVers = MacSwVers.parse(swVersOutput);
                name = swVers.getProductName();
                displayName = swVers.getProductName() + " " + swVers.getProductVersion();
                version = SemanticVersion.parse(swVers.getProductVersion());
                String versionName = MacReleases.getVersionName(version.getMajor(), version.getMinor());
                if (versionName != null) {
                    displayName = displayName + " (" + versionName + ")";
                }
            }
            catch (Exception e) {
                log.warn("Unable to execute 'sw_ver' to detect system platform: {}", (Object)e.getMessage());
            }
        }
        if ((detectSet.contains((Object)Detect.ALL) || detectSet.contains((Object)Detect.LIBC)) && operatingSystem == OperatingSystem.LINUX && (libcResult = PlatformInfo.detectLibC(systemExecutor)) != null) {
            libC = libcResult.getLibC();
            libCVersion = libcResult.getVersion();
        }
        log.debug("Completed detecting platform info in {} ms", (Object)(System.currentTimeMillis() - startTime));
        if (operatingSystem == null || hardwareArchitecture == null) {
            throw new IllegalStateException("Unable to detect platform details (both os and arch were null)");
        }
        return new PlatformInfo(operatingSystem, hardwareArchitecture, name, displayName, version, kernelVersion, Optional.ofNullable(uname).map(Uname::getSource).orElse(null), libC, libCVersion);
    }

    private static LibCResult detectLibC(SystemExecutor systemExecutor) {
        SemanticVersion version;
        LibC libC;
        block6: {
            libC = null;
            version = null;
            try {
                log.debug("Trying to detect libc version via 'ldd /bin/ls' output...");
                String lddOutput = systemExecutor.execProcess("ldd", "/bin/ls");
                LibCs.PathResult pathResult = LibCs.parsePath(lddOutput);
                if (pathResult == null || pathResult.getLibC() == null) break block6;
                libC = pathResult.getLibC();
                try {
                    log.debug("Detected libc {} with path {} (will now try to detect version...)", (Object)pathResult.getLibC(), (Object)pathResult.getPath());
                    String libcOutput = systemExecutor.execProcess(Collections.emptyList(), pathResult.getPath());
                    String versionString = LibCs.parseVersion(libcOutput);
                    if (versionString != null) {
                        version = SemanticVersion.parse(versionString);
                    }
                }
                catch (Exception ex) {
                    log.warn("Unable to execute {} to detect libc version: {}", (Object)pathResult.getPath(), (Object)ex.getMessage());
                }
            }
            catch (Exception e) {
                log.debug("Unable to execute 'ldd' to detect libc version: {}", (Object)e.getMessage());
            }
        }
        if (libC != null) {
            return new LibCResult(libC, version);
        }
        return null;
    }

    public static PlatformInfo detectBasic() {
        return new PlatformInfo(PlatformInfo.detectOperatingSystem(), PlatformInfo.detectHardwareArchitecture(), null, null, null, null, null, PlatformInfo.detectLinuxLibC(), null);
    }

    public static OperatingSystem detectOperatingSystem() {
        return operatingSystemRef.once(new MemoizedInitializer.Initializer<OperatingSystem>(){

            @Override
            public OperatingSystem init() {
                return PlatformInfo.doDetectOperatingSystem();
            }
        });
    }

    static OperatingSystem doDetectOperatingSystem() {
        String osName = System.getProperty("os.name");
        long now = System.currentTimeMillis();
        log.trace("Trying to detect operating system via system property [{}]", (Object)osName);
        OperatingSystem operatingSystem = PlatformInfo.detectOperatingSystemFromValues(osName);
        if (operatingSystem != null) {
            log.debug("Detected operating system {} (in {} ms)", (Object)operatingSystem, (Object)(System.currentTimeMillis() - now));
        } else {
            log.warn("Unable to detect operating system (in {} ms)", (Object)(System.currentTimeMillis() - now));
        }
        return operatingSystem;
    }

    static OperatingSystem detectOperatingSystemFromValues(String osName) {
        return OperatingSystem.resolve(osName);
    }

    public static HardwareArchitecture detectHardwareArchitecture() {
        return hardwareArchitectureRef.once(new MemoizedInitializer.Initializer<HardwareArchitecture>(){

            @Override
            public HardwareArchitecture init() {
                return PlatformInfo.doDetectHardwareArchitecture();
            }
        });
    }

    static HardwareArchitecture doDetectHardwareArchitecture() {
        String osArch = System.getProperty("os.arch");
        String abiType = System.getProperty("sun.arch.abi");
        String bootLibPath = System.getProperty("sun.boot.library.path", "").toLowerCase();
        LinuxDetectedFilesResult linuxMappedFilesResult = PlatformInfo.detectLinuxMappedFiles();
        long now = System.currentTimeMillis();
        HardwareArchitecture hardwareArchitecture = PlatformInfo.detectHardwareArchitectureFromValues(osArch, abiType, bootLibPath, linuxMappedFilesResult);
        if (hardwareArchitecture != null) {
            log.debug("Detected hardware architecture {} (in {} ms)", (Object)hardwareArchitecture, (Object)(System.currentTimeMillis() - now));
        } else {
            log.warn("Unable to detect hardware architecture (in {} ms)", (Object)(System.currentTimeMillis() - now));
        }
        return hardwareArchitecture;
    }

    static HardwareArchitecture detectHardwareArchitectureFromValues(String osArch, String abiType, String bootLibPath, LinuxDetectedFilesResult linuxMappedFilesResult) {
        log.trace("Trying to detect hardware architecture via sysprops arch={}, abi={}, bootpath={}", new Object[]{osArch, abiType, bootLibPath});
        if (osArch != null) {
            osArch = osArch.toLowerCase();
            abiType = abiType != null ? abiType.toLowerCase() : "none";
            bootLibPath = bootLibPath != null ? bootLibPath.toLowerCase() : "none";
            HardwareArchitecture hardwareArchitecture = HardwareArchitecture.resolve(osArch);
            if (hardwareArchitecture != null) {
                return hardwareArchitecture;
            }
            if (osArch.contains("arm") || osArch.contains("aarch32")) {
                log.trace("System property arch [{}] is ambiguous, will try a few workarounds", (Object)osArch);
                if ("gnueabihf".equals(abiType)) {
                    return HardwareArchitecture.ARMHF;
                }
                if (bootLibPath.contains("armhf") || bootLibPath.contains("aarch32hf")) {
                    return HardwareArchitecture.ARMHF;
                }
                if ("gnueabi".equals(abiType)) {
                    return HardwareArchitecture.ARMEL;
                }
                if (bootLibPath.contains("armsf") || bootLibPath.contains("aarch32sf")) {
                    return HardwareArchitecture.ARMEL;
                }
                if (linuxMappedFilesResult != null && linuxMappedFilesResult.getArch() != null && linuxMappedFilesResult.getArch() != null) {
                    return linuxMappedFilesResult.getArch();
                }
            }
        }
        return null;
    }

    public static ABI detectAbi(OperatingSystem os) {
        if (os == null) {
            return null;
        }
        return abiRefs.computeIfAbsent(os, PlatformInfo::doDetectAbi);
    }

    static ABI doDetectAbi(OperatingSystem os) {
        long now = System.currentTimeMillis();
        ABI abi = null;
        if (os == OperatingSystem.LINUX) {
            LibC libC = PlatformInfo.detectLinuxLibC();
            switch (Optional.ofNullable(libC).orElse(LibC.GLIBC)) {
                case MUSL: {
                    abi = ABI.MUSL;
                    break;
                }
                case GLIBC: {
                    abi = ABI.GNU;
                }
            }
        }
        if (abi == null) {
            abi = ABI.DEFAULT;
        }
        log.debug("Detected {} abi {} (in {} ms)", new Object[]{os, abi, System.currentTimeMillis() - now});
        return abi;
    }

    public static LibC detectLinuxLibC() {
        return linuxLibCRef.once(new MemoizedInitializer.Initializer<LibC>(){

            @Override
            public LibC init() {
                LinuxDetectedFilesResult detectedFilesResult = PlatformInfo.detectLinuxMappedFiles();
                if (detectedFilesResult != null && detectedFilesResult.getLibc() != null) {
                    return detectedFilesResult.getLibc();
                }
                detectedFilesResult = PlatformInfo.detectLinuxLibFiles();
                if (detectedFilesResult != null && detectedFilesResult.getLibc() != null) {
                    return detectedFilesResult.getLibc();
                }
                if (detectedFilesResult == null) {
                    return null;
                }
                log.debug("Will assume we are running on GLIBC");
                return LibC.GLIBC;
            }
        });
    }

    public static LinuxDetectedFilesResult detectLinuxLibFiles() {
        return libFilesResultRef.once(new MemoizedInitializer.Initializer<LinuxDetectedFilesResult>(){

            @Override
            public LinuxDetectedFilesResult init() {
                return PlatformInfo.doDetectLinuxLibFiles();
            }
        });
    }

    static LinuxDetectedFilesResult doDetectLinuxLibFiles() {
        OperatingSystem os = PlatformInfo.detectOperatingSystem();
        if (os != OperatingSystem.LINUX) {
            return null;
        }
        long now = System.currentTimeMillis();
        Path libDir = Paths.get("/lib/", new String[0]);
        log.trace("Trying to detect libc/arch via [{}]", (Object)libDir);
        LinuxDetectedFilesResult result = new LinuxDetectedFilesResult();
        try {
            File[] mapFiles;
            if (Files.exists(libDir, new LinkOption[0]) && (mapFiles = libDir.toFile().listFiles()) != null) {
                for (File mapFile : mapFiles) {
                    try {
                        log.trace("Analyzing file {}", (Object)mapFile);
                        String name = mapFile.getName().toLowerCase();
                        if (name.contains("musl") && result.getLibc() == null) {
                            log.debug("Detected libc MUSL via /lib dir strategy (in {} ms)", (Object)(System.currentTimeMillis() - now));
                            result.setLibc(LibC.MUSL);
                        }
                        if (name.contains("armhf") || name.contains("arm-linux-gnueabihf")) {
                            if (result.getArch() == HardwareArchitecture.ARMHF) continue;
                            log.debug("Detected hardware architecture ARMHF via /lib dir strategy (in {} ms)", (Object)(System.currentTimeMillis() - now));
                            result.setArch(HardwareArchitecture.ARMHF);
                            continue;
                        }
                        if (!name.contains("armel") && !name.contains("arm-linux-gnueabi") || result.getArch() == HardwareArchitecture.ARMEL) continue;
                        log.debug("Detected hardware architecture ARMEL via /lib dir strategy (in {} ms)", (Object)(System.currentTimeMillis() - now));
                        result.setArch(HardwareArchitecture.ARMEL);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    public static LinuxDetectedFilesResult detectLinuxMappedFiles() {
        return mappedFilesResultRef.once(new MemoizedInitializer.Initializer<LinuxDetectedFilesResult>(){

            @Override
            public LinuxDetectedFilesResult init() {
                return PlatformInfo.doDetectLinuxMappedFiles();
            }
        });
    }

    static LinuxDetectedFilesResult doDetectLinuxMappedFiles() {
        OperatingSystem os = PlatformInfo.detectOperatingSystem();
        if (os != OperatingSystem.LINUX) {
            return null;
        }
        long now = System.currentTimeMillis();
        Path mapFilesDir = Paths.get("/proc/self/map_files", new String[0]);
        log.trace("Trying to detect libc/arch via [{}]", (Object)mapFilesDir);
        LinuxDetectedFilesResult result = new LinuxDetectedFilesResult();
        boolean possiblyFoundGlibc = false;
        try {
            File[] mapFiles;
            if (Files.exists(mapFilesDir, new LinkOption[0]) && (mapFiles = mapFilesDir.toFile().listFiles()) != null) {
                for (File mapFile : mapFiles) {
                    try {
                        String _realMapFilePath = PlatformInfo.realpath(mapFile.toPath());
                        log.trace("Analyzing file {}", (Object)_realMapFilePath);
                        String realMapFilePath = _realMapFilePath.toLowerCase();
                        if (realMapFilePath.contains("musl")) {
                            if (result.getLibc() == null) {
                                log.debug("Detected libc MUSL via mapped files strategy (in {} ms)", (Object)(System.currentTimeMillis() - now));
                                result.setLibc(LibC.MUSL);
                            }
                        } else if (realMapFilePath.contains("/libc")) {
                            possiblyFoundGlibc = true;
                        }
                        if (realMapFilePath.contains("armhf") || realMapFilePath.contains("arm-linux-gnueabihf")) {
                            if (result.getArch() == HardwareArchitecture.ARMHF) continue;
                            log.debug("Detected hardware architecture ARMHF via mapped files strategy (in {} ms)", (Object)(System.currentTimeMillis() - now));
                            result.setArch(HardwareArchitecture.ARMHF);
                            continue;
                        }
                        if (!realMapFilePath.contains("armel") && !realMapFilePath.contains("arm-linux-gnueabi") || result.getArch() == HardwareArchitecture.ARMEL) continue;
                        log.debug("Detected hardware architecture ARMEL via mapped files strategy (in {} ms)", (Object)(System.currentTimeMillis() - now));
                        result.setArch(HardwareArchitecture.ARMEL);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (possiblyFoundGlibc) {
            log.debug("Detected libc GLIBC via mapped files strategy (in {} ms)", (Object)(System.currentTimeMillis() - now));
            result.setLibc(LibC.GLIBC);
        }
        if (result.getLibc() == null) {
            log.debug("Unable to detect libc via mapped files strategy (in {} ms)", (Object)(System.currentTimeMillis() - now));
        }
        return result;
    }

    private static String realpath(Path file) throws IOException {
        try {
            return file.toRealPath(new LinkOption[0]).toString();
        }
        catch (IOException ioe1) {
            try {
                return Files.readSymbolicLink(file).toString();
            }
            catch (IOException iOException) {
                throw ioe1;
            }
        }
    }

    public static class LinuxDetectedFilesResult {
        private LibC libc;
        private HardwareArchitecture arch;

        public LibC getLibc() {
            return this.libc;
        }

        public void setLibc(LibC libc) {
            this.libc = libc;
        }

        public HardwareArchitecture getArch() {
            return this.arch;
        }

        public void setArch(HardwareArchitecture arch) {
            this.arch = arch;
        }
    }

    public static enum Detect {
        VERSION,
        LIBC,
        ALL;

    }
}

