/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.jne;

public enum OperatingSystem {
    WINDOWS("Windows", null, new String[]{"win"}),
    MACOS("MacOS", new String[]{"osx", "darwin"}, new String[]{"mac"}),
    LINUX("Linux", null, null),
    FREEBSD("FreeBSD", null),
    OPENBSD("OpenBSD", null),
    NETBSD("NetBSD", null),
    DRAGONFLYBSD("DragonFlyBSD", new String[]{"DragonFly"}, new String[]{"dflybsd"}),
    SOLARIS("Solaris", new String[]{"sun"}, new String[]{"sunos"}),
    AIX("AIX", null),
    ANDROID("Android", null),
    HAIKU("Haiku", null);

    private final String descriptor;
    private final String[] aliases;
    private final String[] extraAliases;

    private OperatingSystem(String descriptor, String[] aliases) {
        this(descriptor, aliases, null);
    }

    private OperatingSystem(String descriptor, String[] aliases, String[] extraAliases) {
        this.descriptor = descriptor;
        this.aliases = aliases;
        this.extraAliases = extraAliases;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public String[] getExtraAliases() {
        return this.extraAliases;
    }

    public static OperatingSystem resolve(String value) {
        if (value == null) {
            return null;
        }
        if ((value = value.toLowerCase()).contains("windows")) {
            return WINDOWS;
        }
        if (value.contains("mac") || value.contains("darwin")) {
            return MACOS;
        }
        for (OperatingSystem os : OperatingSystem.values()) {
            if (os.name().equalsIgnoreCase(value)) {
                return os;
            }
            if (os.aliases != null) {
                for (String alias : os.aliases) {
                    if (!alias.equalsIgnoreCase(value)) continue;
                    return os;
                }
            }
            if (os.extraAliases == null) continue;
            for (String extraAlias : os.extraAliases) {
                if (!extraAlias.equalsIgnoreCase(value)) continue;
                return os;
            }
        }
        return null;
    }
}

