/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.jne.internal;

import com.fizzed.jne.internal.SystemExecutor;
import com.fizzed.jne.internal.Utils;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WindowsRegistry {
    private static final Logger log = LoggerFactory.getLogger(WindowsRegistry.class);
    private final Map<String, String> values;

    public WindowsRegistry(Map<String, String> values) {
        this.values = values;
    }

    public Map<String, String> getValues() {
        return this.values;
    }

    public String get(String key) {
        return this.values.get(key);
    }

    public static WindowsRegistry queryUserEnvironmentVariables(SystemExecutor systemExecutor) throws Exception {
        return WindowsRegistry.query(systemExecutor, "HKEY_CURRENT_USER\\Environment");
    }

    public static WindowsRegistry querySystemEnvironmentVariables(SystemExecutor systemExecutor) throws Exception {
        return WindowsRegistry.query(systemExecutor, "HKLM\\SYSTEM\\CurrentControlSet\\Control\\Session Manager\\Environment");
    }

    public static WindowsRegistry queryCurrentVersion(SystemExecutor systemExecutor) throws Exception {
        return WindowsRegistry.query(systemExecutor, "HKLM\\SOFTWARE\\Microsoft\\Windows NT\\CurrentVersion");
    }

    public static WindowsRegistry queryComputerName(SystemExecutor systemExecutor) throws Exception {
        return WindowsRegistry.query(systemExecutor, "HKLM\\SYSTEM\\CurrentControlSet\\Control\\ComputerName\\ComputerName");
    }

    public static WindowsRegistry query(SystemExecutor systemExecutor, String key) throws Exception {
        String output = systemExecutor.execProcess(Arrays.asList(0), "reg.exe", "query", "\"" + key + "\"");
        return WindowsRegistry.parse(output);
    }

    public static WindowsRegistry parse(String output) throws IOException {
        String line;
        TreeMap<String, String> values = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (int pos = 0; pos < output.length(); pos += line.length() + 1) {
            int nextNewlinePos = output.indexOf(10, pos);
            line = output.substring(pos, nextNewlinePos >= 0 ? nextNewlinePos : output.length());
            if ((line = line.trim()).isEmpty() || line.startsWith("HKEY_")) continue;
            if (line.contains("REG_")) {
                int regStartPos = line.indexOf("REG_");
                if (regStartPos >= 0) {
                    int regEndPos = Utils.indexOfAny(line, regStartPos + 1, ' ', '\t', '\r', '\n');
                    regEndPos = regEndPos >= 0 ? regEndPos : line.length();
                    String name = line.substring(0, regStartPos).trim();
                    String type = line.substring(regStartPos, regEndPos).trim();
                    String value = regEndPos < line.length() - 1 ? WindowsRegistry.parseType(type, line.substring(regEndPos + 1).trim()) : null;
                    values.put(name, value);
                    continue;
                }
                log.warn("Unable to parse reg query output line: {}", (Object)line);
                continue;
            }
            log.warn("Unexpected windows req query line: {}", (Object)line);
        }
        return new WindowsRegistry(values);
    }

    public static String parseType(String type, String value) {
        if (value == null || value.isEmpty()) {
            return value;
        }
        if ("REG_DWORD".equalsIgnoreCase(type)) {
            String hex = value.substring(2);
            int dwordValue = Integer.parseInt(hex, 16);
            return Integer.toString(dwordValue);
        }
        return value;
    }
}

