/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.jne.internal;

public class Uname {
    private final String sysname;
    private final String nodename;
    private final String version;
    private final String flavor;
    private final String machine;
    private final String processor;
    private final String hardwarePlatform;
    private final String operatingSystem;
    private final String source;

    private Uname(String sysname, String nodename, String version, String flavor, String machine, String processor, String hardwarePlatform, String operatingSystem, String source) {
        this.sysname = sysname;
        this.nodename = nodename;
        this.version = version;
        this.flavor = flavor;
        this.machine = machine;
        this.processor = processor;
        this.hardwarePlatform = hardwarePlatform;
        this.operatingSystem = operatingSystem;
        this.source = source;
    }

    public static Uname parse(String content) {
        String hardwarePlatform;
        String processor;
        String version;
        String machine;
        String operatingSystem;
        if (content == null) {
            throw new IllegalArgumentException("Input string cannot be null");
        }
        String[] parts = (content = content.trim()).split("\\s+");
        if (parts.length < 5) {
            throw new IllegalArgumentException("Invalid uname -a output: expected at least 5 fields.");
        }
        String sysname = parts[0];
        String nodename = parts[1];
        String release = parts[2];
        String lastField = parts[parts.length - 1];
        if ("Linux".equals(sysname) && (lastField.startsWith("GNU") || lastField.toLowerCase().contains("linux"))) {
            operatingSystem = parts[parts.length - 1];
            int yearIndex = -1;
            for (int i = parts.length - 2; i >= 3; --i) {
                if (parts[i].length() != 4 || !Uname.isNumeric(parts[i])) continue;
                yearIndex = i;
                break;
            }
            if (yearIndex == -1) {
                machine = parts[parts.length - 2];
                version = Uname.joinParts(parts, 3, parts.length - 3);
                processor = null;
                hardwarePlatform = null;
            } else {
                version = Uname.joinParts(parts, 3, yearIndex);
                int fieldsAfterYear = parts.length - 2 - yearIndex;
                if (fieldsAfterYear == 3) {
                    machine = parts[yearIndex + 1];
                    processor = parts[yearIndex + 2];
                    hardwarePlatform = parts[yearIndex + 3];
                } else if (fieldsAfterYear == 2) {
                    machine = parts[yearIndex + 1];
                    processor = parts[yearIndex + 2];
                    hardwarePlatform = null;
                } else if (fieldsAfterYear == 1) {
                    machine = parts[yearIndex + 1];
                    processor = null;
                    hardwarePlatform = null;
                } else {
                    machine = parts[parts.length - 2];
                    version = Uname.joinParts(parts, 3, parts.length - 3);
                    processor = null;
                    hardwarePlatform = null;
                }
            }
        } else {
            machine = parts[parts.length - 1];
            version = Uname.joinParts(parts, 3, parts.length - 2);
            processor = null;
            hardwarePlatform = null;
            operatingSystem = null;
        }
        return new Uname(sysname, nodename, release, version, machine, processor, hardwarePlatform, operatingSystem, content);
    }

    private static boolean isNumeric(String s) {
        if (s == null || s.isEmpty()) {
            return false;
        }
        for (char c : s.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    private static String joinParts(String[] parts, int start, int end) {
        if (start > end) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = start; i <= end; ++i) {
            sb.append(parts[i]);
            if (i >= end) continue;
            sb.append(" ");
        }
        return sb.toString();
    }

    public String getSysname() {
        return this.sysname;
    }

    public String getNodename() {
        return this.nodename;
    }

    public String getVersion() {
        return this.version;
    }

    public String getFlavor() {
        return this.flavor;
    }

    public String getMachine() {
        return this.machine;
    }

    public String getProcessor() {
        return this.processor;
    }

    public String getHardwarePlatform() {
        return this.hardwarePlatform;
    }

    public String getOperatingSystem() {
        return this.operatingSystem;
    }

    public String getSource() {
        return this.source;
    }

    public String toString() {
        return "Uname (Parsed):\n  sysname          : " + this.sysname + "\n  nodename         : " + this.nodename + "\n  release          : " + this.version + "\n  version          : " + this.flavor + "\n  machine          : " + this.machine + "\n  processor        : " + (this.processor != null ? this.processor : "N/A") + "\n  hardwarePlatform : " + (this.hardwarePlatform != null ? this.hardwarePlatform : "N/A") + "\n  operatingSystem  : " + (this.operatingSystem != null ? this.operatingSystem : "N/A");
    }
}

