/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.jne.internal;

import com.fizzed.jne.internal.SystemExecutor;
import com.fizzed.jne.internal.Utils;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcPasswd {
    private static final Logger log = LoggerFactory.getLogger(EtcPasswd.class);
    private final List<Entry> entries;

    public EtcPasswd(List<Entry> entries) {
        this.entries = entries;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public Entry findEntryByUserName(String userName) {
        if (userName == null) {
            return null;
        }
        for (Entry entry : this.entries) {
            if (!Objects.equals(entry.getUsername(), userName)) continue;
            return entry;
        }
        return null;
    }

    public Entry findEntryByUserId(Integer userId) {
        if (userId == null) {
            return null;
        }
        for (Entry entry : this.entries) {
            if (!Objects.equals(entry.getUserId(), userId)) continue;
            return entry;
        }
        return null;
    }

    public static EtcPasswd detect() {
        return EtcPasswd.detect(SystemExecutor.LOCAL);
    }

    public static EtcPasswd detect(SystemExecutor systemExecutor) {
        try {
            String output = systemExecutor.catFile("/etc/passwd");
            return EtcPasswd.parse(output);
        }
        catch (Exception e) {
            log.debug("Unable to parse etc passwd file: {}", (Object)e.getMessage());
            return null;
        }
    }

    public static EtcPasswd parse(Path file) throws IOException {
        String content = Utils.readFileToString(file);
        return EtcPasswd.parse(content);
    }

    public static EtcPasswd parse(String content) throws IOException {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        for (String line : content.split("\n")) {
            String[] parts = (line = line.trim()).split(":");
            if (parts.length != 7) continue;
            Entry entry = new Entry();
            entry.setUsername(parts[0]);
            entry.setUserId(Integer.valueOf(parts[2]));
            entry.setGroupId(Integer.valueOf(parts[3]));
            entry.setName(parts[4]);
            entry.setHome(parts[5]);
            entry.setShell(parts[6]);
            entries.add(entry);
        }
        return new EtcPasswd(entries);
    }

    public static class Entry {
        private String username;
        private Integer userId;
        private Integer groupId;
        private String name;
        private String home;
        private String shell;

        public String getUsername() {
            return this.username;
        }

        public Entry setUsername(String username) {
            this.username = username;
            return this;
        }

        public Integer getUserId() {
            return this.userId;
        }

        public Entry setUserId(Integer userId) {
            this.userId = userId;
            return this;
        }

        public Integer getGroupId() {
            return this.groupId;
        }

        public Entry setGroupId(Integer groupId) {
            this.groupId = groupId;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Entry setName(String name) {
            this.name = name;
            return this;
        }

        public String getHome() {
            return this.home;
        }

        public Entry setHome(String home) {
            this.home = home;
            return this;
        }

        public String getShell() {
            return this.shell;
        }

        public Entry setShell(String shell) {
            this.shell = shell;
            return this;
        }
    }
}

