/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.jne;

import com.fizzed.jne.HardwareArchitecture;
import com.fizzed.jne.JavaDistribution;
import com.fizzed.jne.JavaHome;
import com.fizzed.jne.JavaHomes;
import com.fizzed.jne.JavaImageType;
import com.fizzed.jne.ResourceNotFoundException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class JavaHomeFinder {
    public static final JavaDistribution[] DEFAULT_PREFERRED_DISTRIBUTIONS = new JavaDistribution[]{JavaDistribution.ZULU, JavaDistribution.LIBERICA, JavaDistribution.NITRO, JavaDistribution.TEMURIN, JavaDistribution.MICROSOFT, JavaDistribution.CORRETTO};
    private JavaImageType imageType;
    private HardwareArchitecture hardwareArchitecture;
    private Integer minVersion;
    private Integer maxVersion;
    private JavaDistribution distribution;
    private JavaDistribution[] preferredDistributions;

    public JavaImageType getImageType() {
        return this.imageType;
    }

    public JavaHomeFinder jdk() {
        this.imageType = JavaImageType.JDK;
        return this;
    }

    public JavaHomeFinder jre() {
        this.imageType = JavaImageType.JRE;
        return this;
    }

    public JavaHomeFinder nik() {
        this.imageType = JavaImageType.NIK;
        return this;
    }

    public JavaHomeFinder imageType(JavaImageType imageType) {
        this.imageType = imageType;
        return this;
    }

    public HardwareArchitecture getHardwareArchitecture() {
        return this.hardwareArchitecture;
    }

    public JavaHomeFinder hardwareArchitecture(HardwareArchitecture hardwareArchitecture) {
        this.hardwareArchitecture = hardwareArchitecture;
        return this;
    }

    public Integer getMinVersion() {
        return this.minVersion;
    }

    public JavaHomeFinder minVersion(Integer minVersion) {
        this.minVersion = minVersion;
        return this;
    }

    public Integer getMaxVersion() {
        return this.maxVersion;
    }

    public JavaHomeFinder maxVersion(Integer maxVersion) {
        this.maxVersion = maxVersion;
        return this;
    }

    public JavaHomeFinder version(Integer version) {
        this.maxVersion = version;
        this.minVersion = version;
        return this;
    }

    public JavaDistribution getDistribution() {
        return this.distribution;
    }

    public JavaHomeFinder distribution(JavaDistribution distribution) {
        this.distribution = distribution;
        return this;
    }

    public JavaDistribution[] getPreferredDistributions() {
        return this.preferredDistributions;
    }

    public JavaHomeFinder preferredDistributions() {
        this.preferredDistributions = DEFAULT_PREFERRED_DISTRIBUTIONS;
        return this;
    }

    public JavaHomeFinder preferredDistributions(JavaDistribution ... preferredDistributions) {
        this.preferredDistributions = preferredDistributions;
        return this;
    }

    public String toString() {
        return "imageType=" + (Object)((Object)this.imageType) + ", minVersion=" + this.minVersion + ", maxVersion=" + this.maxVersion + ", hwArch=" + (Object)((Object)this.hardwareArchitecture) + ", distribution=" + (Object)((Object)this.distribution) + ", preferredDistributions=" + Arrays.toString((Object[])this.preferredDistributions) + '}';
    }

    public JavaHome find() throws ResourceNotFoundException {
        List<JavaHome> javaHomes;
        try {
            javaHomes = JavaHomes.detect();
        }
        catch (Exception e) {
            throw new ResourceNotFoundException("Unable to find Java", e);
        }
        return this.find(javaHomes);
    }

    public JavaHome find(List<JavaHome> javaHomes) throws ResourceNotFoundException {
        return this.tryFind(javaHomes).orElseThrow(() -> new ResourceNotFoundException("Unable to find Java with criteria " + this.toString()));
    }

    public Optional<JavaHome> tryFind() {
        List<JavaHome> javaHomes;
        try {
            javaHomes = JavaHomes.detect();
        }
        catch (Exception e) {
            return Optional.empty();
        }
        return this.tryFind(javaHomes);
    }

    public Optional<JavaHome> tryFind(List<JavaHome> javaHomes) {
        if (javaHomes == null || javaHomes.isEmpty()) {
            return Optional.empty();
        }
        List filteredJavaHomes = javaHomes.stream().filter(v -> this.minVersion == null || v.getVersion().getMajor() >= this.minVersion).filter(v -> this.maxVersion == null || v.getVersion().getMajor() <= this.maxVersion).filter(v -> this.imageType == null || v.getImageType() == this.imageType).filter(v -> this.hardwareArchitecture == null || v.getHardwareArchitecture() == this.hardwareArchitecture).filter(v -> this.distribution == null || v.getDistribution() == this.distribution).sorted((a, b) -> b.getVersion().compareTo(a.getVersion())).collect(Collectors.toList());
        if (this.preferredDistributions != null) {
            for (JavaDistribution d : this.preferredDistributions) {
                for (JavaHome javaHome : filteredJavaHomes) {
                    if (javaHome.getDistribution() != d) continue;
                    return Optional.of(javaHome);
                }
            }
        }
        return filteredJavaHomes.stream().findFirst();
    }
}

