/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.jne;

public enum HardwareArchitecture {
    X32("x32", new String[]{"i386", "i586", "i686"}),
    X64("x64", new String[]{"x86_64", "amd64"}),
    ARMEL("armel", null, new String[]{"arm32v5", "arm32v6"}),
    ARMHF("armhf", null, new String[]{"arm32v7"}),
    ARM64("arm64", new String[]{"aarch64"}, new String[]{"arm64v8"}),
    RISCV64("riscv64", null, new String[]{"riscv64gc"}),
    MIPS64LE("mips64le", null),
    S390X("s390x", null),
    PPC64LE("ppc64le", null);

    private final String descriptor;
    private final String[] aliases;
    private final String[] extraAliases;

    private HardwareArchitecture(String descriptor, String[] aliases) {
        this(descriptor, aliases, null);
    }

    private HardwareArchitecture(String descriptor, String[] aliases, String[] extraAliases) {
        this.descriptor = descriptor;
        this.aliases = aliases;
        this.extraAliases = extraAliases;
    }

    public String getDescriptor() {
        return this.descriptor;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public String[] getExtraAliases() {
        return this.extraAliases;
    }

    public static HardwareArchitecture resolve(String value) {
        for (HardwareArchitecture arch : HardwareArchitecture.values()) {
            if (arch.name().equalsIgnoreCase(value)) {
                return arch;
            }
            if (arch.getAliases() != null) {
                for (String alias : arch.getAliases()) {
                    if (!alias.equalsIgnoreCase(value)) continue;
                    return arch;
                }
            }
            if (arch.getExtraAliases() == null) continue;
            for (String alias : arch.getExtraAliases()) {
                if (!alias.equalsIgnoreCase(value)) continue;
                return arch;
            }
        }
        return null;
    }
}

