/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.jne;

public enum HardwareArchitecture {
    ANY,
    UNKNOWN,
    X32,
    X64,
    ARM32,
    ARM64,
    SPARC;


    public static HardwareArchitecture detect() {
        return HardwareArchitecture.parseSystemProperty(System.getProperty("os.arch"));
    }

    public static HardwareArchitecture parseSystemProperty(String value) {
        if (value != null) {
            if ((value = value.toLowerCase()).contains("amd64") || value.contains("x86_64")) {
                return X64;
            }
            if (value.contains("i386") || value.contains("x86")) {
                return X32;
            }
            if (value.contains("aarch64")) {
                return ARM64;
            }
            if (value.contains("aarch32")) {
                return ARM32;
            }
            if (value.contains("sparc")) {
                return SPARC;
            }
        }
        return UNKNOWN;
    }
}

