/*
 * Decompiled with CFR 0.152.
 */
package com.fizzed.jne;

import com.fizzed.jne.Arch;
import com.fizzed.jne.ExtractException;
import com.fizzed.jne.JarUtil;
import com.fizzed.jne.OS;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JNE {
    private static final Logger log = LoggerFactory.getLogger(JNE.class);
    public static final String SYSPROP_DEBUG = "jne.debug";
    public static final String SYSPROP_RESOURCE_PREFIX = "jne.resource.prefix";
    public static final String SYSPROP_EXTRACT_DIR = "jne.extract.dir";
    public static final String SYSPROP_CLEANUP_EXTRACTED = "jne.cleanup.extracted";
    public static final String SYSPROP_X32_EXE_FALLBACK = "jne.x32.exe.fallback";
    public static Options DEFAULT_OPTIONS = new Options();
    private static final int TEMP_DIR_ATTEMPTS = 100;
    private static File _tempDir;
    private static final ConcurrentHashMap<File, String> jarVersionHashes;

    private static File getSystemPropertyAsFile(String key, File defaultValue) {
        String v = System.getProperty(key);
        if (v != null && !v.equals("")) {
            return new File(v);
        }
        return defaultValue;
    }

    private static boolean getSystemPropertyAsBoolean(String key, boolean defaultValue) {
        String v = System.getProperty(key);
        if (v != null) {
            if (v.equalsIgnoreCase("true") || v.equalsIgnoreCase("1")) {
                return true;
            }
            if (v.equalsIgnoreCase("false") || v.equalsIgnoreCase("0")) {
                return false;
            }
            throw new IllegalArgumentException("Invalid boolean value for system property [" + key + "]");
        }
        return defaultValue;
    }

    public static synchronized File findExecutable(String name) throws IOException, ExtractException {
        return JNE.findExecutable(name, null, DEFAULT_OPTIONS);
    }

    public static synchronized File findExecutable(String name, String targetName) throws IOException, ExtractException {
        return JNE.findExecutable(name, targetName, DEFAULT_OPTIONS);
    }

    public static synchronized File findExecutable(String name, String targetName, Options options) throws IOException, ExtractException {
        File f;
        OS os = OS.getOS();
        Arch arch = Arch.getArch();
        String fileName = options.createExecutableName(name, os);
        String targetFileName = null;
        if (targetName != null) {
            targetFileName = options.createExecutableName(targetName, os);
        }
        if ((f = JNE.find(fileName, targetFileName, options, os, arch)) == null && options.isX32ExecutableFallback() && arch == Arch.X64) {
            f = JNE.find(fileName, targetFileName, options, os, Arch.X32);
        }
        return f;
    }

    public static synchronized File findLibrary(String name) {
        return JNE.findLibrary(name, null, null);
    }

    public static synchronized File findLibrary(String name, Integer majorVersion) {
        return JNE.findLibrary(name, null, majorVersion);
    }

    public static synchronized File findLibrary(String name, Options options, Integer majorVersion) {
        OS os = OS.getOS();
        Arch arch = Arch.getArch();
        if (options == null) {
            options = DEFAULT_OPTIONS;
        }
        String fileName = options.createLibraryName(name, os, majorVersion, null, null);
        try {
            return JNE.find(fileName, null, options, os, arch);
        }
        catch (ExtractException | IOException e) {
            throw new UnsatisfiedLinkError(e.getMessage());
        }
    }

    public static synchronized void loadLibrary(String name) {
        JNE.loadLibrary(name, null, null);
    }

    public static synchronized void loadLibrary(String name, Integer majorVersion) {
        JNE.loadLibrary(name, null, majorVersion);
    }

    public static synchronized void loadLibrary(String name, Options options, Integer majorVersion) {
        File f = null;
        try {
            f = JNE.findLibrary(name, options, majorVersion);
        }
        catch (Exception e) {
            log.debug("exception while finding library: " + e.getMessage());
            throw new UnsatisfiedLinkError("Unable to cleanly find (or extract) library [" + name + "] as resource");
        }
        if (f != null) {
            log.debug("System.load(" + f.getAbsolutePath() + ")");
            System.load(f.getAbsolutePath());
        } else {
            log.debug("falling back to System.loadLibrary(" + name + ")");
            System.loadLibrary(name);
        }
        log.debug("library [" + name + "] loaded!");
    }

    public static synchronized File find(String fileName, String targetFileName, Options options, OS os, Arch arch) throws IOException, ExtractException {
        if (options == null) {
            options = DEFAULT_OPTIONS;
        }
        if (os == null || os == OS.UNKNOWN) {
            throw new ExtractException("Unable to detect operating system (e.g. Windows)");
        }
        if (arch == null || arch == Arch.UNKNOWN) {
            throw new ExtractException("Unable to detect hardware architecture (e.g. x86)");
        }
        if (targetFileName == null) {
            targetFileName = fileName;
        }
        log.debug("finding fileName [" + fileName + "] targetFileName [" + targetFileName + "] os [" + (Object)((Object)os) + "] arch [" + (Object)((Object)arch) + "]...");
        String resourcePath = options.createResourcePath(os, arch, fileName);
        log.debug("finding resource [" + resourcePath + "]");
        URL url = JNE.class.getResource(resourcePath);
        if (url == null) {
            log.debug("resource [" + resourcePath + "] not found");
            return null;
        }
        log.debug("resource found @ " + url);
        if (url.getProtocol().equals("jar")) {
            log.debug("resource in jar; extracting file if necessary...");
            String versionHash = JNE.getJarVersionHashForResource(url);
            log.debug("version hash [" + versionHash + "]");
            File d = options.getExtractDir();
            if (d == null) {
                d = JNE.getOrCreateTempDirectory(options.isCleanupExtracted());
            } else {
                if (!d.exists()) {
                    d.mkdirs();
                }
                if (!d.isDirectory()) {
                    throw new ExtractException("Extract dir [" + d + "] is not a directory");
                }
            }
            log.debug("using dir [" + d + "]");
            File exeFile = new File(d, targetFileName);
            File exeHashFile = new File(exeFile.getAbsolutePath() + ".hash");
            if (exeFile.exists()) {
                log.debug("file already exists; verifying if hash matches");
                if (!exeHashFile.exists()) {
                    exeFile.delete();
                } else {
                    String existingHash = JNE.readFileToString(exeHashFile);
                    if (existingHash == null || !existingHash.equals(versionHash)) {
                        log.debug("hash mismatch; deleting files; will freshly extract file");
                        exeFile.delete();
                        exeHashFile.delete();
                    } else {
                        log.debug("hash matches; will use existing file");
                        return exeFile;
                    }
                }
            }
            if (!exeFile.exists()) {
                try {
                    log.debug("extracting [" + url + "] to [" + exeFile + "]...");
                    JNE.extractTo(url, exeFile);
                    log.debug("setting to executable");
                    exeFile.setExecutable(true);
                    log.debug("writing hash file");
                    JNE.writeStringToFile(exeHashFile, versionHash);
                    if (options.isCleanupExtracted()) {
                        log.debug("scheduling file and hash for delete on exit");
                        exeFile.deleteOnExit();
                        exeHashFile.deleteOnExit();
                    }
                }
                catch (IOException e) {
                    log.debug("failed to extract file");
                    throw new ExtractException("Unable to cleanly extract executable from jar", e);
                }
            }
            log.debug("returning [" + exeFile + "]");
            return exeFile;
        }
        if (url.getProtocol().equals("file")) {
            log.debug("resource in file");
            try {
                File exeFile = new File(url.toURI());
                if (!exeFile.canExecute()) {
                    log.debug("setting file to executable");
                    if (!exeFile.setExecutable(true)) {
                        log.debug("unable to cleanly set file to executable");
                        throw new ExtractException("Executable was found but it cannot be set to execute [" + exeFile.getAbsolutePath() + "]");
                    }
                }
                log.debug("returning [" + exeFile + "]");
                return exeFile;
            }
            catch (URISyntaxException e) {
                log.debug("uri syntax error");
                throw new ExtractException("Unable to create executable file from uri", e);
            }
        }
        throw new ExtractException("Unsupported executable resource protocol [" + url.getProtocol() + "]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void extractTo(URL url, File file) throws IOException {
        try (InputStream in = url.openStream();
             BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file, false));){
            int len;
            byte[] buffer = new byte[8192];
            while ((len = in.read(buffer)) > -1) {
                ((OutputStream)out).write(buffer, 0, len);
            }
            ((OutputStream)out).flush();
        }
    }

    private static String readFileToString(File file) throws IOException {
        StringBuilder result = new StringBuilder();
        try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));){
            int len;
            byte[] buf = new byte[1024];
            while ((len = is.read(buf)) > -1) {
                result.append(new String(buf, 0, len, "UTF-8"));
            }
        }
        return result.toString();
    }

    private static void writeStringToFile(File file, String s) throws IOException {
        try (FileOutputStream os = new FileOutputStream(file, false);){
            os.write(s.getBytes("UTF-8"));
            os.flush();
        }
    }

    private static String getJarVersionHashForResource(URL resource) throws IOException {
        File jarFile = JarUtil.getJarFileForResource(resource);
        if (jarVersionHashes.containsKey(jarFile)) {
            return jarVersionHashes.get(jarFile);
        }
        String manifestVersion = JarUtil.getManifestVersionNumber(jarFile);
        StringBuilder hashBuilder = new StringBuilder();
        hashBuilder.append("file:");
        hashBuilder.append(jarFile.getAbsolutePath());
        hashBuilder.append("|last_modified:");
        hashBuilder.append(jarFile.lastModified());
        hashBuilder.append("|version:");
        hashBuilder.append(manifestVersion);
        String hash = hashBuilder.toString();
        jarVersionHashes.put(jarFile, hash);
        return hash;
    }

    private static File getOrCreateTempDirectory(boolean deleteOnExit) throws ExtractException {
        if (_tempDir != null && _tempDir.exists()) {
            return _tempDir;
        }
        File baseDir = new File(System.getProperty("java.io.tmpdir"));
        String baseName = System.currentTimeMillis() + "-";
        for (int counter = 0; counter < 100; ++counter) {
            File d = new File(baseDir, baseName + counter);
            if (!d.mkdir()) continue;
            if (deleteOnExit) {
                d.deleteOnExit();
            }
            _tempDir = d;
            return d;
        }
        throw new ExtractException("Failed to create temporary directory within 100 attempts (tried " + baseName + "0 to " + baseName + 99 + ')');
    }

    static /* synthetic */ File access$000(String x0, File x1) {
        return JNE.getSystemPropertyAsFile(x0, x1);
    }

    static /* synthetic */ boolean access$100(String x0, boolean x1) {
        return JNE.getSystemPropertyAsBoolean(x0, x1);
    }

    static {
        jarVersionHashes = new ConcurrentHashMap();
    }

    public static class Options {
        private String resourcePrefix = System.getProperty("jne.resource.prefix", "/jne");
        private File extractDir = JNE.access$000("jne.extract.dir", null);
        private boolean x32ExecutableFallback = JNE.access$100("jne.x32.exe.fallback", true);
        private boolean cleanupExtracted = JNE.access$100("jne.cleanup.extracted", true);

        public String getResourcePrefix() {
            return this.resourcePrefix;
        }

        public void setResourcePrefix(String resourcePrefix) {
            this.resourcePrefix = resourcePrefix;
        }

        public File getExtractDir() {
            return this.extractDir;
        }

        public void setExtractDir(File extractDir) {
            this.extractDir = extractDir;
        }

        public boolean isX32ExecutableFallback() {
            return this.x32ExecutableFallback;
        }

        public void setX32ExecutableFallback(boolean x32ExecutableFallback) {
            this.x32ExecutableFallback = x32ExecutableFallback;
        }

        public boolean isCleanupExtracted() {
            return this.cleanupExtracted;
        }

        public void setCleanupExtracted(boolean cleanupExtracted) {
            this.cleanupExtracted = cleanupExtracted;
        }

        public String createExecutableName(String name, OS os) {
            if (os == OS.WINDOWS) {
                return name + ".exe";
            }
            return name;
        }

        public String createLibraryName(String name, OS os, Integer majorVersion, Integer minorVersion, Integer revisionVersion) {
            switch (os) {
                case WINDOWS: {
                    return name + ".dll";
                }
                case LINUX: {
                    String soname = "lib" + name + ".so";
                    if (majorVersion != null) {
                        soname = soname + "." + majorVersion;
                        if (minorVersion != null) {
                            soname = soname + "." + minorVersion;
                            if (revisionVersion != null) {
                                soname = soname + "." + revisionVersion;
                            }
                        }
                    }
                    return soname;
                }
                case OSX: {
                    return "lib" + name + ".dylib";
                }
            }
            return name;
        }

        public String createResourcePath(OS os, Arch arch, String name) {
            StringBuilder s = new StringBuilder();
            s.append(this.getResourcePrefix());
            s.append("/");
            s.append(os.name().toLowerCase());
            s.append("/");
            if (arch != null && arch != Arch.ANY) {
                s.append(arch.name().toLowerCase());
                s.append("/");
            }
            s.append(name);
            return s.toString();
        }
    }

    public static enum FindType {
        EXECUTABLE,
        LIBRARY,
        FILE;

    }
}

