/*
 * Decompiled with CFR 0.152.
 */
package com.fitbur.testify.unit;

import com.fitbur.guava.common.base.Preconditions;
import com.fitbur.testify.Cut;
import com.fitbur.testify.Fake;
import com.fitbur.testify.TestReifier;
import com.fitbur.testify.descriptor.CutDescriptor;
import com.fitbur.testify.descriptor.FieldDescriptor;
import com.fitbur.testify.descriptor.ParameterDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.util.Optional;
import org.mockito.AdditionalAnswers;
import org.mockito.Mockito;
import org.mockito.internal.util.MockUtil;
import org.mockito.stubbing.Answer;

public class UnitTestReifier
implements TestReifier {
    private static final MockUtil MOCK_UTIL = new MockUtil();
    private final Object testInstance;

    public UnitTestReifier(Object object) {
        this.testInstance = object;
    }

    public Object reifyField(FieldDescriptor fieldDescriptor, ParameterDescriptor parameterDescriptor) {
        return AccessController.doPrivileged(() -> {
            try {
                Object object = null;
                Optional optional = fieldDescriptor.getAnnotation(Fake.class);
                if (optional.isPresent()) {
                    Field field = fieldDescriptor.getField();
                    field.setAccessible(true);
                    Object object2 = field.get(this.testInstance);
                    object = object2 == null ? Mockito.mock(field.getType()) : (MOCK_UTIL.isMock(object2) ? object2 : Mockito.mock(field.getType(), (Answer)AdditionalAnswers.delegatesTo((Object)object2)));
                    field.set(this.testInstance, object);
                    fieldDescriptor.setInstance(object);
                    parameterDescriptor.setInstance(object);
                }
                return object;
            }
            catch (IllegalAccessException | IllegalArgumentException exception) {
                Preconditions.checkState((boolean)false, (String)"Field '%s' in test class '%s' is not accessible.\n", (Object[])new Object[]{fieldDescriptor.getName(), this.testInstance.getClass().getSimpleName(), exception.getMessage()});
                throw new RuntimeException(exception);
            }
        });
    }

    public Object reifyCut(CutDescriptor cutDescriptor, Object[] objectArray) {
        return AccessController.doPrivileged(() -> {
            try {
                Cut cut = (Cut)cutDescriptor.getCut().get();
                Field field = cutDescriptor.getField();
                field.setAccessible(true);
                Constructor constructor = cutDescriptor.getConstructor();
                constructor.setAccessible(true);
                Object object = constructor.newInstance(objectArray);
                if (cut.value()) {
                    object = Mockito.spy(object);
                }
                field.set(this.testInstance, object);
                cutDescriptor.setInstance(object);
                cutDescriptor.setArguments(objectArray);
                return object;
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException reflectiveOperationException) {
                Preconditions.checkState((boolean)false, (String)"Cut '%s' in test class '%s' could not be created.\n%s", (Object[])new Object[]{cutDescriptor.getName(), this.testInstance.getClass().getSimpleName(), reflectiveOperationException.getMessage()});
                throw new RuntimeException(reflectiveOperationException);
            }
        });
    }

    public void reifyField(CutDescriptor cutDescriptor, FieldDescriptor fieldDescriptor, FieldDescriptor fieldDescriptor2) {
        AccessController.doPrivileged(() -> {
            Field field = fieldDescriptor2.getField();
            Field field2 = fieldDescriptor.getField();
            try {
                field.setAccessible(true);
                field2.setAccessible(true);
                Object object = Mockito.mock(field2.getType());
                Field field3 = Field.class.getDeclaredField("modifiers");
                field3.setAccessible(true);
                field3.setInt(field2, field2.getModifiers() & 0xFFFFFFEF);
                field2.set(cutDescriptor.getInstance().get(), object);
                field.set(this.testInstance, object);
                return object;
            }
            catch (IllegalAccessException | NoSuchFieldException | SecurityException exception) {
                Preconditions.checkState((boolean)false, (String)"Could not set field of type '%s' of Cut '%s' and test class '%s'.\n%s", (Object[])new Object[]{field.getType(), cutDescriptor.getName(), this.testInstance.getClass().getSimpleName(), exception.getMessage()});
                throw new RuntimeException(exception);
            }
        });
    }
}

