/*
 * Decompiled with CFR 0.152.
 */
package com.fitbur.testify.descriptor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Qualifier;

public class ParameterDescriptor {
    private final Parameter parameter;
    private final Integer index;
    private Optional<Object> instance = Optional.empty();

    public ParameterDescriptor(Parameter parameter, Integer n) {
        this.parameter = parameter;
        this.index = n;
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    public String getName() {
        return this.parameter.getName();
    }

    public Integer getIndex() {
        return this.index;
    }

    public Class<?> getType() {
        return this.parameter.getType();
    }

    public Type getGenericType() {
        return this.parameter.getParameterizedType();
    }

    public String getTypeName() {
        return this.parameter.getType().getSimpleName();
    }

    public Optional<Object> getInstance() {
        return this.instance;
    }

    public void setInstance(Object object) {
        this.instance = Optional.ofNullable(object);
    }

    public <T extends Annotation> Optional<T> getAnnotation(Class<T> clazz) {
        return Stream.of(this.parameter.getDeclaredAnnotation(clazz)).filter(annotation -> annotation.annotationType().equals(clazz)).map(annotation -> annotation).findFirst();
    }

    public Set<? extends Annotation> getAnnotations() {
        return ((Stream)Stream.of(this.parameter.getDeclaredAnnotations()).parallel()).collect(Collectors.toSet());
    }

    public Set<? extends Annotation> getQualifiers() {
        return Stream.of(this.parameter.getDeclaredAnnotations()).filter(annotation -> annotation.annotationType().isAnnotationPresent(Qualifier.class)).collect(Collectors.toSet());
    }

    public <T extends Annotation> Set<T> getAnnotations(Class<T> clazz) {
        return Stream.of(this.parameter.getDeclaredAnnotations()).filter(annotation -> annotation.annotationType().equals(clazz)).map(annotation -> annotation).collect(Collectors.toSet());
    }

    public <T extends Annotation> boolean hasAnnotation(Class<T> clazz) {
        return this.parameter.isAnnotationPresent(clazz);
    }

    public boolean hasAnyAnnotation(Class<? extends Annotation> ... classArray) {
        return Stream.of(classArray).anyMatch(this.parameter::isAnnotationPresent);
    }

    public int hashCode() {
        int n = 7;
        n = 59 * n + Objects.hashCode(this.parameter);
        n = 59 * n + Objects.hashCode(this.index);
        n = 59 * n + Objects.hashCode(this.instance);
        return n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ParameterDescriptor parameterDescriptor = (ParameterDescriptor)object;
        if (!Objects.equals(this.parameter, parameterDescriptor.parameter)) {
            return false;
        }
        if (!Objects.equals(this.index, parameterDescriptor.index)) {
            return false;
        }
        return Objects.equals(this.instance, parameterDescriptor.instance);
    }

    public String toString() {
        return "ParameterDescriptor{parameter=" + this.parameter + ", index=" + this.index + ", instance=" + this.instance + '}';
    }
}

