/*
 * Decompiled with CFR 0.152.
 */
package com.fitbur.testify.descriptor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class MethodDescriptor {
    private final Method method;
    private final Class[] parameterTypes;
    private final Integer order;
    private Optional<Object> instance;

    public MethodDescriptor(Method method, Class[] classArray, Integer n) {
        this.method = method;
        this.parameterTypes = classArray;
        this.order = n;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getName() {
        return this.method.getName();
    }

    public Integer getOrder() {
        return this.order;
    }

    public Optional<Object> getInstance() {
        return this.instance;
    }

    public void setInstance(Object object) {
        this.instance = Optional.ofNullable(object);
    }

    public <T extends Annotation> Optional<T> getAnnotation(Class<T> clazz) {
        return Stream.of(this.method.getDeclaredAnnotation(clazz)).filter(annotation -> annotation.annotationType().equals(clazz)).map(annotation -> annotation).findFirst();
    }

    public Set<? extends Annotation> getAnnotations() {
        return Stream.of(this.method.getDeclaredAnnotations()).collect(Collectors.toSet());
    }

    public <T extends Annotation> List<T> getAnnotations(Class<T> clazz) {
        return Stream.of(this.method.getDeclaredAnnotations()).filter(annotation -> annotation.annotationType().equals(clazz)).map(annotation -> annotation).collect(Collectors.toList());
    }

    public <T extends Annotation> boolean hasAnnotation(Class<T> clazz) {
        return this.method.isAnnotationPresent(clazz);
    }

    public boolean hasAnyAnnotation(Class<? extends Annotation> ... classArray) {
        return Stream.of(classArray).anyMatch(this.method::isAnnotationPresent);
    }

    public List<Class> getParameterTypes() {
        return Stream.of(this.parameterTypes).collect(Collectors.toList());
    }

    public boolean hasParameterTypes(Class ... classArray) {
        return Arrays.equals(this.parameterTypes, classArray);
    }

    public int hashCode() {
        int n = 3;
        n = 67 * n + Objects.hashCode(this.method);
        n = 67 * n + Objects.hashCode(this.order);
        n = 67 * n + Objects.hashCode(this.instance);
        return n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MethodDescriptor methodDescriptor = (MethodDescriptor)object;
        if (!Objects.equals(this.method, methodDescriptor.method)) {
            return false;
        }
        if (!Objects.equals(this.order, methodDescriptor.order)) {
            return false;
        }
        return Objects.equals(this.instance, methodDescriptor.instance);
    }

    public String toString() {
        return "MethodDescriptor{method=" + this.method + ", order=" + this.order + ", instance=" + this.instance + '}';
    }
}

