/*
 * Decompiled with CFR 0.152.
 */
package com.fitbur.testify.descriptor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FieldDescriptor {
    private final Field field;
    private final Integer order;
    private Optional<Object> instance = Optional.empty();

    public FieldDescriptor(Field field, Integer n) {
        this.field = field;
        this.order = n;
    }

    public Field getField() {
        return this.field;
    }

    public String getName() {
        return this.field.getName();
    }

    public Class<?> getType() {
        return this.field.getType();
    }

    public Type getGenericType() {
        return this.field.getGenericType();
    }

    public String getTypeName() {
        return this.field.getType().getSimpleName();
    }

    public Integer getOrder() {
        return this.order;
    }

    public Optional<Object> getInstance() {
        return this.instance;
    }

    public void setInstance(Object object) {
        this.instance = Optional.ofNullable(object);
    }

    public <T extends Annotation> Optional<T> getAnnotation(Class<T> clazz) {
        return Optional.ofNullable(this.field.getDeclaredAnnotation(clazz));
    }

    public Set<? extends Annotation> getAnnotations() {
        return ((Stream)Stream.of(this.field.getDeclaredAnnotations()).parallel()).collect(Collectors.toSet());
    }

    public <T extends Annotation> Set<T> getAnnotations(Class<T> clazz) {
        return ((Stream)Stream.of(this.field.getDeclaredAnnotations()).parallel()).filter(annotation -> annotation.annotationType().equals(clazz)).map(annotation -> annotation).collect(Collectors.toSet());
    }

    public <T extends Annotation> Set<T> getAnnotations(Set<Class<? extends Annotation>> set) {
        return ((Stream)Stream.of(this.field.getDeclaredAnnotations()).parallel()).filter(annotation -> set.contains(annotation.annotationType())).map(annotation -> annotation).collect(Collectors.toSet());
    }

    public <T extends Annotation> boolean hasAnnotation(Class<T> clazz) {
        return this.field.getDeclaredAnnotation(clazz) != null;
    }

    public boolean hasAnyAnnotation(Class<? extends Annotation> ... classArray) {
        return ((Stream)Stream.of(classArray).parallel()).distinct().anyMatch(clazz -> this.field.getDeclaredAnnotation(clazz) != null);
    }

    public boolean hasAnnotations(Collection<Class<? extends Annotation>> collection) {
        return ((Stream)Stream.of(this.field.getDeclaredAnnotations()).parallel()).distinct().anyMatch(annotation -> collection.contains(annotation.annotationType()));
    }

    public int hashCode() {
        int n = 3;
        n = 67 * n + Objects.hashCode(this.field);
        n = 67 * n + Objects.hashCode(this.order);
        n = 67 * n + Objects.hashCode(this.instance);
        return n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        FieldDescriptor fieldDescriptor = (FieldDescriptor)object;
        if (!Objects.equals(this.field, fieldDescriptor.field)) {
            return false;
        }
        if (!Objects.equals(this.order, fieldDescriptor.order)) {
            return false;
        }
        return Objects.equals(this.instance, fieldDescriptor.instance);
    }

    public String toString() {
        return "FieldDescriptor{field=" + this.field + ", order=" + this.order + ", instance=" + this.instance + '}';
    }
}

