/*
 * Decompiled with CFR 0.152.
 */
package com.fitbur.testify.descriptor;

import com.fitbur.testify.Cut;
import com.fitbur.testify.descriptor.DescriptorKey;
import com.fitbur.testify.descriptor.FieldDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CutDescriptor {
    private final Field field;
    private Constructor<?> constructor;
    private Object[] arguments;
    private Optional<Object> instance = Optional.empty();
    private final Map<DescriptorKey, FieldDescriptor> fieldDescriptors = new LinkedHashMap<DescriptorKey, FieldDescriptor>();
    private int fieldCount;

    public CutDescriptor(Field field) {
        this.field = field;
    }

    public Field getField() {
        return this.field;
    }

    public String getName() {
        return this.field.getName();
    }

    public Class<?> getType() {
        return this.field.getType();
    }

    public Type getGenericType() {
        return this.field.getGenericType();
    }

    public String getTypeName() {
        return this.field.getType().getSimpleName();
    }

    public Optional<Cut> getCut() {
        return Optional.ofNullable(this.field.getDeclaredAnnotation(Cut.class));
    }

    public boolean hasCut() {
        return this.field.getDeclaredAnnotation(Cut.class) != null;
    }

    public Optional<Object> getInstance() {
        return this.instance;
    }

    public void setInstance(Object object) {
        this.instance = Optional.ofNullable(object);
    }

    public Constructor<?> getConstructor() {
        return this.constructor;
    }

    public <T extends Annotation> Optional<T> getAnnotation(Class<T> clazz) {
        return Stream.of(this.field.getDeclaredAnnotation(clazz)).filter(annotation -> annotation.annotationType().equals(clazz)).map(annotation -> annotation).findFirst();
    }

    public Set<? extends Annotation> getAnnotations() {
        return Stream.of(this.field.getDeclaredAnnotations()).collect(Collectors.toSet());
    }

    public <T extends Annotation> Set<T> getAnnotations(Class<T> clazz) {
        return Stream.of(this.field.getDeclaredAnnotations()).filter(annotation -> annotation.annotationType().equals(clazz)).map(annotation -> annotation).collect(Collectors.toSet());
    }

    public <T extends Annotation> boolean hasAnnotation(Class<T> clazz) {
        return this.field.getDeclaredAnnotation(clazz) != null;
    }

    public boolean hasAnyAnnotation(Class<? extends Annotation> ... classArray) {
        return ((Stream)Stream.of(classArray).parallel()).distinct().anyMatch(clazz -> this.field.getDeclaredAnnotation(clazz) != null);
    }

    public boolean hasAnnotations(Collection<Class<? extends Annotation>> collection) {
        return ((Stream)Stream.of(this.field.getDeclaredAnnotations()).parallel()).distinct().anyMatch(annotation -> collection.contains(annotation.annotationType()));
    }

    public void setConstructor(Constructor<?> constructor) {
        this.constructor = constructor;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public void setArguments(Object[] objectArray) {
        this.arguments = objectArray;
    }

    public void putFieldDescriptor(DescriptorKey descriptorKey, FieldDescriptor fieldDescriptor) {
        this.fieldDescriptors.put(descriptorKey, fieldDescriptor);
    }

    public Optional<FieldDescriptor> getFieldDescriptor(DescriptorKey descriptorKey) {
        return Optional.ofNullable(this.fieldDescriptors.get(descriptorKey));
    }

    public Map<DescriptorKey, FieldDescriptor> getFieldDescriptors() {
        return Collections.unmodifiableMap(this.fieldDescriptors);
    }

    public int getFieldCount() {
        return this.fieldCount;
    }

    public void setFieldCount(int n) {
        this.fieldCount = n;
    }

    public int hashCode() {
        int n = 7;
        n = 53 * n + Objects.hashCode(this.field);
        n = 53 * n + Objects.hashCode(this.instance);
        n = 53 * n + Objects.hashCode(this.constructor);
        return n;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CutDescriptor cutDescriptor = (CutDescriptor)object;
        if (!Objects.equals(this.field, cutDescriptor.field)) {
            return false;
        }
        if (!Objects.equals(this.instance, cutDescriptor.instance)) {
            return false;
        }
        return Objects.equals(this.constructor, cutDescriptor.constructor);
    }

    public String toString() {
        return "CutDescriptor{field=" + this.field + ", instance=" + this.instance + ", constructor=" + this.constructor + '}';
    }
}

