/*
 * Decompiled with CFR 0.152.
 */
package com.fitbur.testify.analyzer;

import com.fitbur.asm.ClassVisitor;
import com.fitbur.asm.FieldVisitor;
import com.fitbur.asm.MethodVisitor;
import com.fitbur.asm.Type;
import com.fitbur.guava.common.base.Preconditions;
import com.fitbur.testify.Cut;
import com.fitbur.testify.TestContext;
import com.fitbur.testify.descriptor.CutDescriptor;
import com.fitbur.testify.descriptor.DescriptorKey;
import com.fitbur.testify.descriptor.FieldDescriptor;
import com.fitbur.testify.descriptor.MethodDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.stream.Stream;

public class TestClassAnalyzer
extends ClassVisitor {
    public static final String CONSTRUCTOR_NAME = "<init>";
    public static final String STATIC_NAME = "<cinit>";
    private final TestContext context;
    private int fieldCount = 0;
    private int methodCount = 0;
    private int cutCount = 0;

    public TestClassAnalyzer(TestContext testContext) {
        super(327680);
        this.context = testContext;
    }

    public FieldVisitor visitField(int n, String string, String string2, String string3, Object object) {
        try {
            Class<?> clazz = this.context.getTestClass();
            Field field = clazz.getDeclaredField(string);
            Cut cut = field.getDeclaredAnnotation(Cut.class);
            if (cut != null) {
                this.context.setCutDescriptor(new CutDescriptor(field));
                ++this.cutCount;
            } else {
                DescriptorKey descriptorKey = new DescriptorKey(field.getGenericType(), field.getName());
                FieldDescriptor fieldDescriptor = new FieldDescriptor(field, this.fieldCount++);
                this.context.putFieldDescriptor(descriptorKey, fieldDescriptor);
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Preconditions.checkState((boolean)false, (String)"Field '%s' not found in test class '%s'.\n%s", (Object[])new Object[]{string, this.context.getTestClassName(), noSuchFieldException.getMessage()});
        }
        return null;
    }

    public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
        if (CONSTRUCTOR_NAME.equals(string) || STATIC_NAME.equals(string)) {
            return null;
        }
        Class<?> clazz = this.context.getTestClass();
        Type type = Type.getMethodType((String)string2);
        Object[] objectArray = (Class[])((Stream)Stream.of(type.getArgumentTypes()).sequential()).map(Type::getClassName).map(this::getClass).toArray(Class[]::new);
        try {
            Method method = clazz.getDeclaredMethod(string, (Class<?>[])objectArray);
            MethodDescriptor methodDescriptor = new MethodDescriptor(method, (Class[])objectArray, this.methodCount++);
            this.context.addMethodDescriptor(methodDescriptor);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            Preconditions.checkState((boolean)false, (String)"Method with '%s' parameters not accessible in '%s' class.", (Object[])new Object[]{Arrays.toString(objectArray), this.context.getTestClassName()});
        }
        return null;
    }

    public void visitEnd() {
        this.context.setFieldCount(this.fieldCount);
        this.context.setMethodCount(this.methodCount);
        this.context.setCutCount(this.cutCount);
    }

    private Class<?> getClass(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Preconditions.checkState((boolean)false, (String)"Class '%s' not found in the classpath.", (Object[])new Object[]{string});
            throw new IllegalStateException(classNotFoundException);
        }
    }
}

