/*
 * Decompiled with CFR 0.152.
 */
package com.fitbur.testify.analyzer;

import com.fitbur.asm.ClassVisitor;
import com.fitbur.asm.FieldVisitor;
import com.fitbur.asm.MethodVisitor;
import com.fitbur.asm.Type;
import com.fitbur.guava.common.base.Preconditions;
import com.fitbur.testify.TestContext;
import com.fitbur.testify.descriptor.CutDescriptor;
import com.fitbur.testify.descriptor.DescriptorKey;
import com.fitbur.testify.descriptor.FieldDescriptor;
import com.fitbur.testify.descriptor.ParameterDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.security.AccessController;
import java.util.Arrays;
import java.util.stream.Stream;

public class CutClassAnalyzer
extends ClassVisitor {
    public static final String CONSTRUCTOR_NAME = "<init>";
    private final TestContext context;
    private int constCount = 0;
    private int fieldCount = 0;

    public CutClassAnalyzer(TestContext testContext) {
        super(327680);
        this.context = testContext;
    }

    public FieldVisitor visitField(int n, String string, String string2, String string3, Object object) {
        CutDescriptor cutDescriptor = this.context.getCutDescriptor();
        Class<?> clazz = cutDescriptor.getType();
        try {
            Field field = clazz.getDeclaredField(string);
            DescriptorKey descriptorKey = new DescriptorKey(field.getGenericType(), field.getName());
            FieldDescriptor fieldDescriptor = new FieldDescriptor(field, this.fieldCount++);
            cutDescriptor.putFieldDescriptor(descriptorKey, fieldDescriptor);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            Preconditions.checkState((boolean)false, (String)"Field '%s' not found in class under test '%s'.\n%s", (Object[])new Object[]{string, clazz.getSimpleName(), noSuchFieldException.getMessage()});
        }
        return null;
    }

    public MethodVisitor visitMethod(int n, String string, String string2, String string3, String[] stringArray) {
        if (CONSTRUCTOR_NAME.equals(string)) {
            ++this.constCount;
            AccessController.doPrivileged(() -> {
                Type type = Type.getMethodType((String)string2);
                Object[] objectArray = (Class[])((Stream)Stream.of(type.getArgumentTypes()).sequential()).map(this::getClass).toArray(Class[]::new);
                CutDescriptor cutDescriptor = this.context.getCutDescriptor();
                try {
                    Constructor<?> constructor = cutDescriptor.getField().getType().getDeclaredConstructor((Class<?>[])objectArray);
                    cutDescriptor.setConstructor(constructor);
                    Parameter[] parameterArray = constructor.getParameters();
                    for (int i = 0; i < parameterArray.length; ++i) {
                        ParameterDescriptor parameterDescriptor = new ParameterDescriptor(parameterArray[i], i);
                        this.context.addParameterDescriptor(parameterDescriptor);
                    }
                }
                catch (NoSuchMethodException | SecurityException exception) {
                    Preconditions.checkState((boolean)false, (String)"Constructor with '%s' parameters not accessible in '%s' class.", (Object[])new Object[]{Arrays.toString(objectArray), cutDescriptor.getTypeName()});
                }
                return null;
            });
        }
        return null;
    }

    public void visitEnd() {
        this.context.setConstructorCount(this.constCount);
        this.context.getCutDescriptor().setFieldCount(this.fieldCount);
    }

    private Class<?> getClass(Type type) {
        try {
            return Class.forName(type.getInternalName().replace('/', '.'));
        }
        catch (ClassNotFoundException classNotFoundException) {
            Preconditions.checkState((boolean)false, (String)"Class '%s' not found in the classpath.", (Object[])new Object[]{type.getClassName()});
            throw new IllegalStateException(classNotFoundException);
        }
    }
}

