/*
 * Decompiled with CFR 0.152.
 */
package com.fitbur.testify;

import com.fitbur.testify.TestContext;
import com.fitbur.testify.need.NeedDescriptor;
import java.lang.annotation.Annotation;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TestNeedDescriptor
implements NeedDescriptor {
    private final TestContext testContext;
    private final String methodName;

    public TestNeedDescriptor(TestContext testContext, String string) {
        this.testContext = testContext;
        this.methodName = string;
    }

    public Object getTestInstance() {
        return this.testContext.getTestInstance();
    }

    public Class<?> getTestClass() {
        return this.testContext.getTestClass();
    }

    public String getTestClassName() {
        return this.testContext.getTestClassName();
    }

    public String getTestMethodName() {
        return this.methodName;
    }

    public <T extends Annotation> Optional<T> getAnnotation(Class<T> clazz) {
        T t = this.testContext.getTestInstance().getClass().getAnnotation(clazz);
        return Optional.ofNullable(t);
    }

    public <T extends Annotation> Set<T> getAnnotations(Class<T> clazz) {
        Annotation[] annotationArray = this.testContext.getTestInstance().getClass().getAnnotationsByType(clazz);
        return Stream.of(annotationArray).collect(Collectors.toSet());
    }
}

