/*
 * Decompiled with CFR 0.152.
 */
package com.fitbur.testify;

import com.fitbur.guava.common.base.Preconditions;
import com.fitbur.guava.common.collect.Lists;
import com.fitbur.testify.TestContext;
import com.fitbur.testify.TestNeedDescriptor;
import com.fitbur.testify.di.ServiceLocator;
import com.fitbur.testify.need.NeedContainer;
import com.fitbur.testify.need.NeedContainerProvider;
import com.fitbur.testify.need.NeedContext;
import com.fitbur.testify.need.NeedDescriptor;
import com.fitbur.testify.need.NeedProvider;
import com.fitbur.testify.need.NeedScope;
import java.lang.annotation.Annotation;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;

public class TestNeedContainers {
    private final TestContext testContext;
    private final String name;
    private final NeedScope scope;
    private Set<NeedContext> needContexts;

    public TestNeedContainers(TestContext testContext, String string, NeedScope needScope) {
        this.testContext = testContext;
        this.name = string;
        this.scope = needScope;
    }

    public <T extends Annotation> void init() {
        this.needContexts = new HashSet<NeedContext>();
        ServiceLoader<NeedContainerProvider> serviceLoader = ServiceLoader.load(NeedContainerProvider.class);
        ArrayList arrayList = Lists.newArrayList(serviceLoader);
        arrayList.parallelStream().forEach(needContainerProvider -> this.testContext.getAnnotations(NeedContainer.class).parallelStream().filter(needContainer -> needContainer.scope() == this.scope).map(needContainer -> {
            TestNeedDescriptor testNeedDescriptor = new TestNeedDescriptor(this.testContext, this.name);
            Object object = needContainerProvider.configuration((NeedDescriptor)testNeedDescriptor);
            this.testContext.getConfigMethod(object.getClass()).map(methodDescriptor -> methodDescriptor.getMethod()).ifPresent(method -> AccessController.doPrivileged(() -> {
                try {
                    method.setAccessible(true);
                    method.invoke(testNeedDescriptor.getTestInstance(), object);
                }
                catch (Exception exception) {
                    Preconditions.checkState((boolean)false, (String)"Call to config method '%s' in test class '%s' failed.", (Object[])new Object[]{method.getName(), testNeedDescriptor.getTestClassName()});
                }
                return null;
            }));
            Map map = needContainerProvider.init((NeedDescriptor)testNeedDescriptor, object);
            NeedContext needContext = new NeedContext((NeedProvider)needContainerProvider, (NeedDescriptor)testNeedDescriptor, map, object);
            return needContext;
        }).collect(Collectors.toCollection(() -> this.needContexts)));
    }

    public void inject(ServiceLocator serviceLocator) {
        this.needContexts.parallelStream().forEach(needContext -> {
            needContext.getProvider().clean(needContext.getDescriptor(), needContext.getConfiguration());
            serviceLocator.addConstant(UUID.randomUUID().toString(), needContext);
            needContext.getInstances().forEach((string, needInstance) -> {
                serviceLocator.addConstant(UUID.randomUUID().toString(), needInstance.getInstance());
                serviceLocator.addConstant(string, needInstance);
            });
        });
    }

    public void destory() {
        this.needContexts.parallelStream().forEach(needContext -> needContext.getProvider().destroy(needContext.getDescriptor(), needContext.getConfiguration()));
    }
}

