/*
 * Decompiled with CFR 0.152.
 */
package com.fitbur.testify;

import com.fitbur.testify.Config;
import com.fitbur.testify.descriptor.CutDescriptor;
import com.fitbur.testify.descriptor.DescriptorKey;
import com.fitbur.testify.descriptor.FieldDescriptor;
import com.fitbur.testify.descriptor.MethodDescriptor;
import com.fitbur.testify.descriptor.ParameterDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;

public class TestContext {
    private final String name;
    private final Class<?> testClass;
    private final Map<DescriptorKey, FieldDescriptor> fieldDescriptors = new LinkedHashMap<DescriptorKey, FieldDescriptor>();
    private final Set<MethodDescriptor> methodDescriptors = new LinkedHashSet<MethodDescriptor>();
    private final Map<DescriptorKey, ParameterDescriptor> paramaterDescriptors = new LinkedHashMap<DescriptorKey, ParameterDescriptor>();
    private Object testInstance;
    private CutDescriptor cutDescriptor;
    private int cutCount;
    private int methodCount;
    private int fieldCount;
    private final Logger logger;
    private int constructorCount;

    public TestContext(String string, Class<?> clazz, Logger logger) {
        this.name = string;
        this.testClass = clazz;
        this.logger = logger;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public String getName() {
        return this.name;
    }

    public String getTestClassName() {
        return this.testClass.getSimpleName();
    }

    public Class<?> getTestClass() {
        return this.testClass;
    }

    public Object getTestInstance() {
        return this.testInstance;
    }

    public void setTestInstance(Object object) {
        this.testInstance = object;
    }

    public void addParameterDescriptor(ParameterDescriptor parameterDescriptor) {
        Parameter parameter = parameterDescriptor.getParameter();
        Type type = parameter.getParameterizedType();
        String string = parameter.getName();
        this.paramaterDescriptors.put(new DescriptorKey(type, string), parameterDescriptor);
    }

    public Map<DescriptorKey, ParameterDescriptor> getParamaterDescriptors() {
        return Collections.unmodifiableMap(this.paramaterDescriptors);
    }

    public void putFieldDescriptor(DescriptorKey descriptorKey, FieldDescriptor fieldDescriptor) {
        this.fieldDescriptors.put(descriptorKey, fieldDescriptor);
    }

    public Optional<FieldDescriptor> getFieldDescriptor(DescriptorKey descriptorKey) {
        return Optional.ofNullable(this.fieldDescriptors.get(descriptorKey));
    }

    public Map<DescriptorKey, FieldDescriptor> getFieldDescriptors() {
        return Collections.unmodifiableMap(this.fieldDescriptors);
    }

    public void addMethodDescriptor(MethodDescriptor methodDescriptor) {
        this.methodDescriptors.add(methodDescriptor);
    }

    public Set<MethodDescriptor> getMethodDescriptors() {
        return Collections.unmodifiableSet(this.methodDescriptors);
    }

    public Set<MethodDescriptor> getConfigMethods() {
        return this.methodDescriptors.stream().filter(methodDescriptor -> methodDescriptor.hasAnnotation(Config.class)).collect(Collectors.toSet());
    }

    public Optional<MethodDescriptor> getConfigMethod(Class ... classArray) {
        return this.methodDescriptors.stream().filter(methodDescriptor -> methodDescriptor.hasAnnotation(Config.class)).filter(methodDescriptor -> methodDescriptor.hasParameterTypes(classArray)).findFirst();
    }

    public void setCutDescriptor(CutDescriptor cutDescriptor) {
        this.cutDescriptor = cutDescriptor;
    }

    public CutDescriptor getCutDescriptor() {
        return this.cutDescriptor;
    }

    public int getCutCount() {
        return this.cutCount;
    }

    public void setCutCount(int n) {
        this.cutCount = n;
    }

    public int getMethodCount() {
        return this.methodCount;
    }

    public void setMethodCount(int n) {
        this.methodCount = n;
    }

    public int getFieldCount() {
        return this.fieldCount;
    }

    public void setFieldCount(int n) {
        this.fieldCount = n;
    }

    public void setConstructorCount(int n) {
        this.constructorCount = n;
    }

    public int getConstructorCount() {
        return this.constructorCount;
    }

    public Set<? extends Annotation> getAnnotations() {
        return Stream.of(this.testClass.getDeclaredAnnotations()).collect(Collectors.toSet());
    }

    public <T extends Annotation> Optional<T> getAnnotation(Class<T> clazz) {
        return Optional.ofNullable(this.testClass.getDeclaredAnnotation(clazz));
    }

    public <T extends Annotation> Set<T> getAnnotations(Class<T> clazz) {
        return Stream.of(this.testClass.getAnnotationsByType(clazz)).collect(Collectors.toSet());
    }

    public <T extends Annotation> boolean hasAnnotation(Class<T> clazz) {
        return this.testClass.getDeclaredAnnotation(clazz) != null;
    }

    public boolean hasAnyAnnotation(Class<? extends Annotation> ... classArray) {
        return ((Stream)Stream.of(classArray).parallel()).distinct().anyMatch(clazz -> this.testClass.getDeclaredAnnotation(clazz) != null);
    }

    public boolean hasAnnotations(Collection<Class<? extends Annotation>> collection) {
        return ((Stream)Stream.of(this.testClass.getDeclaredAnnotations()).parallel()).distinct().anyMatch(annotation -> collection.contains(annotation.annotationType()));
    }
}

