/*
 * Decompiled with CFR 0.152.
 */
package com.fitbur.testify.server;

import com.fitbur.testify.di.ServiceLocator;
import com.fitbur.testify.server.ServerDescriptor;
import com.fitbur.testify.server.ServerInstance;
import com.fitbur.testify.server.ServerProvider;
import java.util.Objects;

public class ServerContext {
    private final ServerProvider provider;
    private final ServerDescriptor descriptor;
    private final ServerInstance instance;
    private final ServiceLocator locator;
    private final Object config;

    public ServerContext(ServerProvider serverProvider, ServerDescriptor serverDescriptor, ServerInstance serverInstance, ServiceLocator serviceLocator, Object object) {
        this.provider = serverProvider;
        this.descriptor = serverDescriptor;
        this.instance = serverInstance;
        this.locator = serviceLocator;
        this.config = object;
    }

    public ServerProvider getProvider() {
        return this.provider;
    }

    public ServerDescriptor getDescriptor() {
        return this.descriptor;
    }

    public Object getConfig() {
        return this.config;
    }

    public ServerInstance getInstance() {
        return this.instance;
    }

    public ServiceLocator getLocator() {
        return this.locator;
    }

    public int hashCode() {
        int n = 7;
        n = 17 * n + Objects.hashCode(this.provider);
        n = 17 * n + Objects.hashCode(this.descriptor);
        n = 17 * n + Objects.hashCode(this.instance);
        n = 17 * n + Objects.hashCode(this.locator);
        n = 17 * n + Objects.hashCode(this.config);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        ServerContext serverContext = (ServerContext)object;
        if (!Objects.equals(this.provider, serverContext.provider)) {
            return false;
        }
        if (!Objects.equals(this.descriptor, serverContext.descriptor)) {
            return false;
        }
        if (!Objects.equals(this.instance, serverContext.instance)) {
            return false;
        }
        if (!Objects.equals(this.locator, serverContext.locator)) {
            return false;
        }
        return Objects.equals(this.config, serverContext.config);
    }

    public String toString() {
        return "ServerContext{provider=" + this.provider + ", descriptor=" + this.descriptor + ", instance=" + this.instance + ", locator=" + this.locator + ", config=" + this.config + '}';
    }
}

