/*
 * Decompiled with CFR 0.152.
 */
package com.fitbur.testify.need;

import com.fitbur.testify.need.NeedDescriptor;
import com.fitbur.testify.need.NeedInstance;
import com.fitbur.testify.need.NeedProvider;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class NeedContext {
    private final NeedProvider provider;
    private final NeedDescriptor descriptor;
    private final Map<String, NeedInstance> instances;
    private final Object configuration;

    public NeedContext(NeedProvider needProvider, NeedDescriptor needDescriptor, Map<String, NeedInstance> map, Object object) {
        this.provider = needProvider;
        this.descriptor = needDescriptor;
        this.instances = map;
        this.configuration = object;
    }

    public NeedProvider getProvider() {
        return this.provider;
    }

    public NeedDescriptor getDescriptor() {
        return this.descriptor;
    }

    public Map<String, ? extends NeedInstance> getInstances() {
        return this.instances;
    }

    public Optional<NeedInstance> findFirstInstance() {
        return this.instances.values().stream().findFirst();
    }

    public Object getConfiguration() {
        return this.configuration;
    }

    public int hashCode() {
        int n = 5;
        n = 71 * n + Objects.hashCode(this.provider);
        n = 71 * n + Objects.hashCode(this.descriptor);
        n = 71 * n + Objects.hashCode(this.instances);
        n = 71 * n + Objects.hashCode(this.configuration);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        NeedContext needContext = (NeedContext)object;
        if (!Objects.equals(this.provider, needContext.provider)) {
            return false;
        }
        if (!Objects.equals(this.descriptor, needContext.descriptor)) {
            return false;
        }
        if (!Objects.equals(this.instances, needContext.instances)) {
            return false;
        }
        return Objects.equals(this.configuration, needContext.configuration);
    }

    public String toString() {
        return "NeedContext{provider=" + this.provider + ", descriptor=" + this.descriptor + ", instances=" + this.instances + ", context=" + this.configuration + '}';
    }
}

