/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui;

import com.firebase.client.ChildEventListener;
import com.firebase.client.DataSnapshot;
import com.firebase.client.FirebaseError;
import com.firebase.client.Query;
import java.util.ArrayList;

class FirebaseArray
implements ChildEventListener {
    private Query mQuery;
    private OnChangedListener mListener;
    private ArrayList<DataSnapshot> mSnapshots;

    public FirebaseArray(Query ref) {
        this.mQuery = ref;
        this.mSnapshots = new ArrayList();
        this.mQuery.addChildEventListener((ChildEventListener)this);
    }

    public void cleanup() {
        this.mQuery.removeEventListener((ChildEventListener)this);
    }

    public int getCount() {
        return this.mSnapshots.size();
    }

    public DataSnapshot getItem(int index) {
        return this.mSnapshots.get(index);
    }

    private int getIndexForKey(String key) {
        int index = 0;
        for (DataSnapshot snapshot : this.mSnapshots) {
            if (snapshot.getKey().equals(key)) {
                return index;
            }
            ++index;
        }
        throw new IllegalArgumentException("Key not found");
    }

    public void onChildAdded(DataSnapshot snapshot, String previousChildKey) {
        int index = 0;
        if (previousChildKey != null) {
            index = this.getIndexForKey(previousChildKey) + 1;
        }
        this.mSnapshots.add(index, snapshot);
        this.notifyChangedListeners(OnChangedListener.EventType.Added, index);
    }

    public void onChildChanged(DataSnapshot snapshot, String previousChildKey) {
        int index = this.getIndexForKey(snapshot.getKey());
        this.mSnapshots.set(index, snapshot);
        this.notifyChangedListeners(OnChangedListener.EventType.Changed, index);
    }

    public void onChildRemoved(DataSnapshot snapshot) {
        int index = this.getIndexForKey(snapshot.getKey());
        this.mSnapshots.remove(index);
        this.notifyChangedListeners(OnChangedListener.EventType.Removed, index);
    }

    public void onChildMoved(DataSnapshot snapshot, String previousChildKey) {
        int oldIndex = this.getIndexForKey(snapshot.getKey());
        this.mSnapshots.remove(oldIndex);
        int newIndex = previousChildKey == null ? 0 : this.getIndexForKey(previousChildKey) + 1;
        this.mSnapshots.add(newIndex, snapshot);
        this.notifyChangedListeners(OnChangedListener.EventType.Moved, newIndex, oldIndex);
    }

    public void onCancelled(FirebaseError firebaseError) {
    }

    public void setOnChangedListener(OnChangedListener listener) {
        this.mListener = listener;
    }

    protected void notifyChangedListeners(OnChangedListener.EventType type, int index) {
        this.notifyChangedListeners(type, index, -1);
    }

    protected void notifyChangedListeners(OnChangedListener.EventType type, int index, int oldIndex) {
        if (this.mListener != null) {
            this.mListener.onChanged(type, index, oldIndex);
        }
    }

    public static interface OnChangedListener {
        public void onChanged(EventType var1, int var2, int var3);

        public static enum EventType {
            Added,
            Changed,
            Removed,
            Moved;

        }
    }
}

