/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.common;

import android.util.LruCache;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.firebase.ui.common.BaseSnapshotParser;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public abstract class BaseCachingSnapshotParser<S, T>
implements BaseSnapshotParser<S, T> {
    private static final int MAX_CACHE_SIZE = 100;
    private final LruCache<String, T> mObjectCache = new LruCache(100);
    private final BaseSnapshotParser<S, T> mParser;

    public BaseCachingSnapshotParser(@NonNull BaseSnapshotParser<S, T> parser) {
        this.mParser = parser;
    }

    @NonNull
    public abstract String getId(@NonNull S var1);

    @Override
    @NonNull
    public T parseSnapshot(@NonNull S snapshot) {
        String id = this.getId(snapshot);
        Object result = this.mObjectCache.get((Object)id);
        if (result == null) {
            T object = this.mParser.parseSnapshot(snapshot);
            this.mObjectCache.put((Object)id, object);
            result = object;
        }
        return (T)result;
    }

    public void clear() {
        this.mObjectCache.evictAll();
    }

    public void invalidate(@NonNull S snapshot) {
        this.mObjectCache.remove((Object)this.getId(snapshot));
    }
}

