/*
 * Decompiled with CFR 0.152.
 */
package com.firebase.ui.auth.util.data;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.firebase.ui.auth.AuthUI;
import com.firebase.ui.auth.FirebaseUiException;
import com.firebase.ui.auth.IdpResponse;
import com.firebase.ui.auth.R;
import com.firebase.ui.auth.data.model.FlowParameters;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.auth.AuthCredential;
import com.google.firebase.auth.FacebookAuthProvider;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.auth.GoogleAuthProvider;
import com.google.firebase.auth.SignInMethodQueryResult;
import java.util.ArrayList;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class ProviderUtils {
    private static final String GITHUB_IDENTITY = "https://github.com";
    private static final String PHONE_IDENTITY = "https://phone.firebase";

    private ProviderUtils() {
        throw new AssertionError((Object)"No instance for you!");
    }

    @Nullable
    public static AuthCredential getAuthCredential(IdpResponse response) {
        if (response.hasCredentialForLinking()) {
            return response.getCredentialForLinking();
        }
        switch (response.getProviderType()) {
            case "google.com": {
                return GoogleAuthProvider.getCredential((String)response.getIdpToken(), null);
            }
            case "facebook.com": {
                return FacebookAuthProvider.getCredential((String)response.getIdpToken());
            }
        }
        return null;
    }

    @Nullable
    public static String idpResponseToAccountType(@Nullable IdpResponse response) {
        if (response == null) {
            return null;
        }
        return ProviderUtils.providerIdToAccountType(response.getProviderType());
    }

    @NonNull
    public static String signInMethodToProviderId(@NonNull String method) {
        switch (method) {
            case "google.com": {
                return "google.com";
            }
            case "facebook.com": {
                return "facebook.com";
            }
            case "twitter.com": {
                return "twitter.com";
            }
            case "github.com": {
                return "github.com";
            }
            case "phone": {
                return "phone";
            }
            case "password": {
                return "password";
            }
            case "emailLink": {
                return "emailLink";
            }
        }
        return method;
    }

    public static String providerIdToAccountType(@NonNull String providerId) {
        switch (providerId) {
            case "google.com": {
                return "https://accounts.google.com";
            }
            case "facebook.com": {
                return "https://www.facebook.com";
            }
            case "twitter.com": {
                return "https://twitter.com";
            }
            case "github.com": {
                return GITHUB_IDENTITY;
            }
            case "phone": {
                return PHONE_IDENTITY;
            }
        }
        return null;
    }

    public static String accountTypeToProviderId(@NonNull String accountType) {
        switch (accountType) {
            case "https://accounts.google.com": {
                return "google.com";
            }
            case "https://www.facebook.com": {
                return "facebook.com";
            }
            case "https://twitter.com": {
                return "twitter.com";
            }
            case "https://github.com": {
                return "github.com";
            }
            case "https://phone.firebase": {
                return "phone";
            }
        }
        return null;
    }

    public static String providerIdToProviderName(@NonNull String providerId) {
        switch (providerId) {
            case "google.com": {
                return AuthUI.getApplicationContext().getString(R.string.fui_idp_name_google);
            }
            case "facebook.com": {
                return AuthUI.getApplicationContext().getString(R.string.fui_idp_name_facebook);
            }
            case "twitter.com": {
                return AuthUI.getApplicationContext().getString(R.string.fui_idp_name_twitter);
            }
            case "github.com": {
                return AuthUI.getApplicationContext().getString(R.string.fui_idp_name_github);
            }
            case "phone": {
                return AuthUI.getApplicationContext().getString(R.string.fui_idp_name_phone);
            }
            case "password": 
            case "emailLink": {
                return AuthUI.getApplicationContext().getString(R.string.fui_idp_name_email);
            }
        }
        return null;
    }

    @Nullable
    public static AuthUI.IdpConfig getConfigFromIdps(List<AuthUI.IdpConfig> idps, String id2) {
        for (AuthUI.IdpConfig idp : idps) {
            if (!idp.getProviderId().equals(id2)) continue;
            return idp;
        }
        return null;
    }

    @NonNull
    public static AuthUI.IdpConfig getConfigFromIdpsOrThrow(List<AuthUI.IdpConfig> idps, String id2) {
        AuthUI.IdpConfig config = ProviderUtils.getConfigFromIdps(idps, id2);
        if (config == null) {
            throw new IllegalStateException("Provider " + id2 + " not found.");
        }
        return config;
    }

    public static Task<List<String>> fetchSortedProviders(@NonNull FirebaseAuth auth, final @NonNull FlowParameters params, @NonNull String email) {
        if (TextUtils.isEmpty((CharSequence)email)) {
            return Tasks.forException((Exception)new NullPointerException("Email cannot be empty"));
        }
        return auth.fetchSignInMethodsForEmail(email).continueWithTask((Continuation)new Continuation<SignInMethodQueryResult, Task<List<String>>>(){

            public Task<List<String>> then(@NonNull Task<SignInMethodQueryResult> task) {
                ArrayList methods = ((SignInMethodQueryResult)task.getResult()).getSignInMethods();
                if (methods == null) {
                    methods = new ArrayList();
                }
                ArrayList<String> allowedProviders = new ArrayList<String>(params.providers.size());
                for (AuthUI.IdpConfig provider : params.providers) {
                    allowedProviders.add(provider.getProviderId());
                }
                ArrayList<String> lastSignedInProviders = new ArrayList<String>(methods.size());
                for (String method : methods) {
                    String id2 = ProviderUtils.signInMethodToProviderId(method);
                    if (!allowedProviders.contains(id2)) continue;
                    lastSignedInProviders.add(0, id2);
                }
                if (allowedProviders.contains("emailLink") && methods.contains("password") && !methods.contains("emailLink")) {
                    lastSignedInProviders.add(0, ProviderUtils.signInMethodToProviderId("emailLink"));
                }
                if (task.isSuccessful() && lastSignedInProviders.isEmpty() && !methods.isEmpty()) {
                    return Tasks.forException((Exception)new FirebaseUiException(3));
                }
                this.reorderPriorities(lastSignedInProviders);
                return Tasks.forResult(lastSignedInProviders);
            }

            private void reorderPriorities(List<String> providers) {
                this.changePriority(providers, "password", true);
                this.changePriority(providers, "google.com", true);
                this.changePriority(providers, "emailLink", false);
            }

            private void changePriority(List<String> providers, String id2, boolean maximizePriority) {
                if (providers.remove(id2)) {
                    if (maximizePriority) {
                        providers.add(0, id2);
                    } else {
                        providers.add(id2);
                    }
                }
            }
        });
    }

    public static Task<String> fetchTopProvider(@NonNull FirebaseAuth auth, @NonNull FlowParameters params, @NonNull String email) {
        return ProviderUtils.fetchSortedProviders(auth, params, email).continueWithTask(task -> {
            if (!task.isSuccessful()) {
                return Tasks.forException((Exception)task.getException());
            }
            List providers = (List)task.getResult();
            if (providers.isEmpty()) {
                return Tasks.forResult(null);
            }
            return Tasks.forResult((Object)((String)providers.get(0)));
        });
    }
}

